package com.bxm.localnews.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
@ApiModel(description = "定位返回包装类")
public class LocationDetailDTO {

    @ApiModelProperty("地区编码")
    private String code;

    @ApiModelProperty("地区简称")
    private String name;

    @ApiModelProperty("是否热门城市（1表示true）")
    private Byte hot;

    @ApiModelProperty("城市级别（2：市、3：县（区））")
    private Byte level;

    @ApiModelProperty("经度")
    private Double lng;

    @ApiModelProperty("纬度")
    private Double lat;

    @ApiModelProperty("该地区是否开启vip")
    private Byte enableVip;

    @ApiModelProperty("激活VIP需要邀请人数")
    private Integer invitedCount;

    @ApiModelProperty("地区优惠金额")
    private String reductionAmount;

    @ApiModelProperty("该地区是否开启推广赚钱")
    private Byte enablePaidPromote;

    @ApiModelProperty("新人红包")
    private BigDecimal newRedPacket;

    @ApiModelProperty("推广赏金")
    private BigDecimal promoteBounty;

    @ApiModelProperty(value = "是否启用社区内容，1：启用，0：禁用")
    private Integer enableCommunityContent;

    @ApiModelProperty(value = "是否启用首页发帖，1：启用，0：禁用")
    private Integer enableIndexPublish;

    @ApiModelProperty(value = "是否启用客服小助手，1：启用，0：禁用")
    private Integer enableCustomerService;

    @ApiModelProperty("地区全称")
    private String fullName;

    @ApiModelProperty("是否启用签到排行榜，1：启用，0：禁用")
    private Integer enableSignBoard;

    @ApiModelProperty("最新行政编码")
    private String lastCode;

}
