package com.bxm.localnews.common.dto;

import com.bxm.localnews.common.vo.AreaInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

/**
 * @author gonzo
 * @date 2020-08-13 17:05
 **/
@Data
@Builder
public class LocationSwitchDTO {

    @ApiModelProperty("切换类型 0: 弹出城市选择框 1: 强制切换 2: 引导切换（弹出是否要切换到xx城市，可暂时不考虑）")
    private Byte switchType;

    @ApiModelProperty("需要切换的城市信息 如果为空则说明获取不到可用的切换城市信息，弹出城市选择框")
    private AreaInfo areaInfo;

    @Tolerate
    public LocationSwitchDTO() {

    }

}
