package com.bxm.localnews.common.param;

import com.bxm.localnews.common.constant.DomainScene.DomainViewScene;
import com.bxm.localnews.common.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 *
 * @author gonzo
 * @date 2020-07-30 17:01
 **/
@Data
@ApiModel("根据场景获取可用域名信息参数")
public class GetViewSceneDomainInfoParam extends BasicParam {

    /**
     * 场景值 {@link DomainViewScene}
     */
    @ApiModelProperty("CONTENT_VIEW: 站外内容落地页 PROMOTION_VIEW: 站外推广落地页 ACTIVITY_VIEW: 站外活动落地页")
    private String viewScene;

    @ApiModelProperty("appId 有些落地页场景是有公众号配置的 如: WX_JS_VIEW")
    private String appId;

    @ApiModelProperty("是否需要过滤配置的落地页域名 默认都要过滤")
    private boolean exclusionViewScene = true;

}