package com.bxm.localnews.common.vo;

import com.bxm.newidea.component.vo.BaseBean;
import lombok.Data;

import java.util.Date;
import java.util.Objects;

/**
 * 设备基础信息
 * c_equipment_extra_info
 * @author shentao
 */
@Data
public class EquipmentExtraInfo extends BaseBean {
    /**
     * 设备唯一标识
     */
    private String id;

    /**
     * 是否开启消息通知
     */
    private Boolean enableNotification;

    /**
     * 手机型号
     */
    private String phoneModel;

    /**
     * 当前版本
     */
    private String currentVersion;

    /**
     * 操作系统
     */
    private String operatingSystem;

    /**
     * 平台类型
     */
    private Integer platform;

    private Integer enableLocation;

    private Date createTime;

    private Date modifyTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EquipmentExtraInfo that = (EquipmentExtraInfo) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(enableNotification, that.enableNotification) &&
                Objects.equals(phoneModel, that.phoneModel) &&
                Objects.equals(currentVersion, that.currentVersion) &&
                Objects.equals(operatingSystem, that.operatingSystem) &&
                Objects.equals(platform, that.platform);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), id, enableNotification, phoneModel, currentVersion, operatingSystem, platform);
    }
}