package com.bxm.localnews.common.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 用户定位信息配置实体
 *
 * @author
 */
@Data
public class Location implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 地区编码
     */
    private String code;

    /**
     * 地区简称
     */
    private String name;

    /**
     * 地区全称
     */
    private String fullName;

    /**
     * 是否热门城市（1表示true）
     */
    private Byte hot;

    /**
     * 是否显示（1表示true）
     */
    private Byte show;

    /**
     * 城市级别（2：市、3：县（区））
     */
    private Byte level;

    /**
     * 城市拼音或者首字母
     */
    private String pinyin;

    /**
     * 纬度
     */
    private Double lat;

    /**
     * 经度
     */
    private Double lng;

    /**
     * 该地区是否开启vip
     */
    private Byte enableVip;

    /**
     * 激活VIP需要邀请人数
     */
    private Integer invitedCount;

    /**
     * 地区优惠金额
     */
    private String reductionAmount;


    /**
     * 当前区域是否启用推广赚钱
     */
    private Byte enablePaidPromote;

    /**
     * 新人红包金额
     */
    private BigDecimal newRedPacket;

    /**
     * 推广赏金
     */
    private BigDecimal promoteBounty;


    /**
     * 是否启用社区内容，1：启用，0：禁用
     */
    private Integer enableCommunityContent;

    /**
     * 是否启用首页发帖，1：启用，0：禁用
     */
    private Integer enableIndexPublish;

    /**
     * 是否启用客服小助手，1：启用，0：禁用
     */
    private Integer enableCustomerService;

    /**
     * 是否启用签到排行榜，1：启用，0：禁用
     */
    private Integer enableSignBoard;

    /**
     * 客服微信号
     */
    private String customerServiceNumber;

    /**
     * 客服二维码
     */
    private String customerServiceQrCode;

    /**
     * 是否启用团购客服电话，1：启用，0：禁用
     */
    private Integer enableGroupCustomerServicePhone;

    /**
     * 团购客服电话
     */
    private String groupCustomerServicePhone;

    /**
     * 微信公众号
     */
    private String officialAccountQrcode;

    /**
     * 排序
     */
    private int order;

    /**
     * 最新行政编码
     */
    private String lastCode;
}