package com.bxm.localnews.common.vo;

import lombok.Data;

/**
 * 落地页base url信息
 * @author gonzo
 * @date 2020-07-30 16:22
 **/
@Data
public class ViewSceneInfo {

    /**
     * 域名
     */
    private String domain;

    /**
     * 协议 http:// or https://
     */
    private String protocol;

    /**
     * @see com.bxm.localnews.common.constant.DomainScene.DomainViewScene
     * 落地页场景类型
     */
    private String viewScene;

    /**
     * 落地页域名(如 WX_JS_VIEW)对应的appId
     *
     */
    private String appId;

}
