package com.bxm.localnews.common.dto;

import com.bxm.localnews.common.vo.CommonEquipmentApp;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Objects;

@Data
public class EquipmentDTO {

    @ApiModelProperty("服务端的设备唯一标识，客户端在第一次上报时，id为空，在上报完毕得到id后将其缓存至本地，下次上报携带id进行更新(在基础参数中作为devcId)")
    private String id;

    @ApiModelProperty("android:表示唯一值，不同手机返回不同（ IOS_DEVICE_ID/MAC 等 ），本文档中主要用于表示设备唯一码。重置系统不会重置，需要申请权限后获取。")
    private String IMEI;

    @ApiModelProperty("android：安卓系统初始化时创建一次，重置系统会被重置")
    private String androidId;

    @ApiModelProperty("android：每次即生成的uuid")
    private String androidUuid;

    @ApiModelProperty("ios：中的 广告追踪 ID ， 用户可进行重置或阻止追踪 （返回 16 个 0 ）")
    private String idfa;

    @ApiModelProperty("ios：本文档中特指 iOS 设备号，由 App 创建后上传，可保证同一设备同一 App 重复安装仍保持一致")
    private String iosId;

    @ApiModelProperty("是否开启消息通知 否:false")
    private Boolean enableNotification;

    @ApiModelProperty("手机型号")
    private String phoneModel;

    @ApiModelProperty("操作系统版本")
    private String operatingSystem;

    @ApiModelProperty(value = "是否开启定位 0：未开启 1：已开启")
    private Integer enableLocation;

    @ApiModelProperty(value = "通用参数：当前APP的上线版本", required = true)
    private String curVer;

    @ApiModelProperty(value = "通用参数：当前设备平台", required = true)
    private Integer platform;

    private List<CommonEquipmentApp> apps;


    /**
     * 设备唯一信息对比，判断是否有变化
     * @param other
     * @return
     */
    public boolean uniqueEquals(EquipmentDTO other) {
        if (null == other) {
            return false;
        }

        return Objects.equals(iosId, other.iosId)
                && Objects.equals(idfa, other.idfa)
                && Objects.equals(androidUuid, other.androidUuid)
                && Objects.equals(IMEI, other.IMEI)
                && Objects.equals(androidId, other.androidId);
    }

    /**
     * 判断设备信息中的基础信息是否有变化
     * @param other
     * @return
     */
    public boolean baseInfoEquals(EquipmentDTO other) {
        if (null == other) {
            return false;
        }

        return Objects.equals(curVer, other.curVer)
                && Objects.equals(operatingSystem, other.operatingSystem)
                && Objects.equals(phoneModel, other.phoneModel)
                && Objects.equals(enableNotification, other.enableNotification);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EquipmentDTO that = (EquipmentDTO) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(IMEI, that.IMEI) &&
                Objects.equals(androidId, that.androidId) &&
                Objects.equals(androidUuid, that.androidUuid) &&
                Objects.equals(idfa, that.idfa) &&
                Objects.equals(iosId, that.iosId) &&
                Objects.equals(enableNotification, that.enableNotification) &&
                Objects.equals(phoneModel, that.phoneModel) &&
                Objects.equals(operatingSystem, that.operatingSystem) &&
                Objects.equals(enableLocation, that.enableLocation) &&
                Objects.equals(curVer, that.curVer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, IMEI, androidId, androidUuid, idfa, iosId, enableNotification, phoneModel, operatingSystem,enableLocation, curVer);
    }
}
