package com.bxm.localnews.common.entity;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * t_base_domain_publish
 * @author
 */
@Data
public class BaseDomainPublish implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 域名id
     */
    private Long domainId;

    /**
     * 协议 http:// or https://
     */
    private String protocol;

    /**
     * 投放场景 0: 站内H5 1：站内淘宝授权 2: 短链 3: 站外分享域名 4: 站外分享落地页域名  5: 站外微信用户授权中间页 6: 站外微信支付中间页
     */
    private Byte scene;

    /**
     * 如果域名场景是落地页域名 则该字段标识落地页场景 0: 非落地页域名 1: 站外内容落地页 2: 站外推广落地页 3: 站外活动落地页
     */
    private Byte viewScene;

    /**
     * 如果涉及到公众号授权，则当前域名绑定的公众号信息
     */
    private String appId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态 1可用 0不可用
     */
    private Byte status;

    private Date createTime;

    private Date modifyTime;

    private static final long serialVersionUID = 1L;
}