/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.AreaInfoMapper;
import com.bxm.localnews.base.dto.LocationFacadeDTO;
import com.bxm.localnews.base.service.AreaInfoService;
import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AreaInfoServiceImpl
extends BaseService
implements AreaInfoService {
    private final AreaInfoMapper areaInfoMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final LocationService locationService;

    @Autowired
    public AreaInfoServiceImpl(AreaInfoMapper areaInfoMapper, RedisStringAdapter redisStringAdapter, LocationService locationService) {
        this.areaInfoMapper = areaInfoMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.locationService = locationService;
    }

    @Override
    public AreaInfo getAreaInfo(String code) {
        Optional<AreaInfo> areaInfoOptional;
        LocationFacadeDTO locationDTO = this.locationService.getInternalLocationByGeocode(code);
        KeyGenerator areaInfoKey = RedisConfig.AREA_INFO;
        TypeReference<List<AreaInfo>> areaInfoTypeReference = new TypeReference<List<AreaInfo>>(){};
        AreaInfo areaInfo = null;
        List areaInfoList = (List)this.redisStringAdapter.get(areaInfoKey, (TypeReference)areaInfoTypeReference);
        if (areaInfoList != null && (areaInfoOptional = areaInfoList.stream().filter(x -> x.getCode().equals(code)).findFirst()).isPresent()) {
            areaInfo = areaInfoOptional.get();
        }
        if (null == areaInfo) {
            areaInfoList = this.areaInfoMapper.selectByModel(null);
            this.redisStringAdapter.set(areaInfoKey, (Object)areaInfoList);
            areaInfo = this.areaInfoMapper.selectByCode(code);
        }
        if (null == areaInfo) {
            areaInfo = new AreaInfo();
        }
        areaInfo.setCode(locationDTO.getCode());
        areaInfo.setName(locationDTO.getName());
        return areaInfo;
    }
}

