/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.domain.AreaCodeMapper;
import com.bxm.localnews.base.domain.AreaDivisionMapper;
import com.bxm.localnews.base.domain.LocationMapper;
import com.bxm.localnews.base.dto.LocationDetailDTO;
import com.bxm.localnews.base.dto.LocationFacadeDTO;
import com.bxm.localnews.base.service.LocationFacadeService;
import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.AreaDivisionDTO;
import com.bxm.localnews.common.dto.CustomerServiceDTO;
import com.bxm.localnews.common.dto.LocationDTO;
import com.bxm.localnews.common.dto.LocationMeta;
import com.bxm.localnews.common.vo.AreaCode;
import com.bxm.localnews.common.vo.AreaDivision;
import com.bxm.localnews.common.vo.Location;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationServiceImpl
extends BaseService
implements LocationService,
LocationFacadeService {
    private static final Logger LOG = LoggerFactory.getLogger(LocationServiceImpl.class);
    private static final int AREA_CODE_LENGTH = 12;
    private static final int AREA_CODE_HALF_LENGTH = 6;
    private final AreaCodeMapper areaCodeMapper;
    @Autowired
    private AreaDivisionMapper areaDivisionMapper;
    @Autowired
    private LocationMapper locationMapper;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private BizConfigProperties bizConfigProperties;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public LocationServiceImpl(AreaCodeMapper areaCodeMapper) {
        this.areaCodeMapper = areaCodeMapper;
    }

    @Override
    public AreaCode selectByAreaName(String name, String province) {
        List areaCodeList = this.areaCodeMapper.selectByAreaName(province);
        if (areaCodeList != null) {
            for (AreaCode areaCode : areaCodeList) {
                String codeSplit;
                List areaList;
                String tail = areaCode.getAreaCode().substring(2, 6);
                if (!"0000".equalsIgnoreCase(tail) || (areaList = this.areaCodeMapper.selectByAreaCode(name, codeSplit = areaCode.getAreaCode().substring(0, 2))) == null) continue;
                return (AreaCode)areaList.get(0);
            }
        }
        return null;
    }

    @Override
    public LocationMeta listLocation() {
        TypeReference<List<LocationDTO>> openedCityTypeReference;
        KeyGenerator openedCityKey;
        List<LocationDTO> openedLocationList;
        KeyGenerator hotCityKey = RedisConfig.HOT_LOCATION;
        TypeReference<List<LocationDTO>> hotCityTypeReference = new TypeReference<List<LocationDTO>>(){};
        List<LocationDTO> hotLocationList = (List<LocationDTO>)this.redisStringAdapter.get(hotCityKey, (TypeReference)hotCityTypeReference);
        if (hotLocationList == null) {
            hotLocationList = this.listHotLocation();
            this.redisStringAdapter.set(hotCityKey, hotLocationList);
        }
        if ((openedLocationList = (List<LocationDTO>)this.redisStringAdapter.get(openedCityKey = RedisConfig.OPENED_LOCATION, (TypeReference)(openedCityTypeReference = new TypeReference<List<LocationDTO>>(){}))) == null) {
            openedLocationList = this.listOpenedLocation();
            this.redisStringAdapter.set(openedCityKey, openedLocationList);
        }
        LocationMeta locationMeta = new LocationMeta();
        locationMeta.setHotLocation(hotLocationList);
        locationMeta.setOpenedLocation(openedLocationList);
        return locationMeta;
    }

    @Override
    public List<AreaDivisionDTO> listAreaDivisionDTO(String parentCode) {
        AreaDivision areaDivisionParam = new AreaDivision();
        areaDivisionParam.setParentCode(parentCode);
        List areaDivisionList = this.areaDivisionMapper.selectByModel(areaDivisionParam);
        return areaDivisionList.stream().map(this::convertDivision).collect(Collectors.toList());
    }

    @Override
    public LocationFacadeDTO getInternalLocationByGeocode(String code) {
        LocationFacadeDTO locationDTO = null;
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            String fullCode;
            if (12 == code.length() && null == (locationDTO = this.getLocationByCode(code))) {
                code = code.substring(0, 6);
            }
            if (6 == code.length() && null == (locationDTO = this.getLocationByCode(fullCode = code + "000000"))) {
                fullCode = code.substring(0, 4) + "00000000";
                locationDTO = this.getLocationByCode(fullCode);
            }
        }
        if (null == locationDTO) {
            locationDTO = new LocationFacadeDTO();
            locationDTO.setCode(this.bizConfigProperties.getLocationCode());
            locationDTO.setName(this.bizConfigProperties.getLocationName());
        }
        return locationDTO;
    }

    private AreaDivisionDTO convertDivision(AreaDivision areaDivision) {
        AreaDivisionDTO areaDivisionDTO = new AreaDivisionDTO();
        areaDivisionDTO.setCode(areaDivision.getCode());
        areaDivisionDTO.setLevel(areaDivision.getLevel());
        areaDivisionDTO.setName(areaDivision.getName());
        return areaDivisionDTO;
    }

    private List<LocationDTO> listHotLocation() {
        Location locationParam = new Location();
        locationParam.setHot(Byte.valueOf((byte)1));
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        return locationDTOList;
    }

    private List<LocationDTO> listOpenedLocation() {
        Location locationParam = new Location();
        locationParam.setShow(Byte.valueOf((byte)1));
        List locationList = this.locationMapper.selectByModel(locationParam);
        List<LocationDTO> locationDTOList = locationList.stream().map(this::convertLocation).collect(Collectors.toList());
        locationDTOList.forEach(x -> x.setPinyin(x.getPinyin().substring(0, 1).toUpperCase()));
        return locationDTOList;
    }

    private LocationDTO convertLocation(Location location) {
        LocationDTO locationDTO = new LocationDTO();
        locationDTO.setCode(location.getCode());
        locationDTO.setHot(location.getHot());
        locationDTO.setLevel(location.getLevel());
        locationDTO.setName(location.getName());
        locationDTO.setPinyin(location.getPinyin().substring(0, 1).toUpperCase());
        return locationDTO;
    }

    public LocationFacadeDTO getLocationByCode(String code) {
        LocationFacadeDTO locationDTO = null;
        Location location = this.locationMapper.selectByCode(code);
        if (null != location) {
            locationDTO = new LocationFacadeDTO();
            BeanUtils.copyProperties((Object)location, (Object)locationDTO);
        }
        return locationDTO;
    }

    public LocationDetailDTO getLocationDetailByCode(String code) {
        LocationDetailDTO locationDTO = null;
        Location location = this.locationMapper.selectByCode(code);
        if (null != location) {
            locationDTO = new LocationDetailDTO();
            BeanUtils.copyProperties((Object)location, (Object)locationDTO);
        }
        return locationDTO;
    }

    public LocationDetailDTO getAcitivateVipLocation() {
        LocationDetailDTO locationDTO = null;
        Location location = this.locationMapper.selectActivateLocation();
        if (null != location) {
            locationDTO = new LocationDetailDTO();
            BeanUtils.copyProperties((Object)location, (Object)locationDTO);
        }
        return locationDTO;
    }

    public boolean compareLocationCode(String originalCode, List<String> standardCodeList) {
        this.logger.debug("\u53c2\u52a0\u6d3b\u52a8\u5730\u533a\u7f16\u7801\u76f8\u6bd4\u8f83\uff0c\u7528\u6237\u5730\u533a\u7f16\u53f7\uff1a{} \uff0c\u6d3b\u52a8\u5730\u533a\u5217\u8868\uff1a{}", (Object)originalCode, standardCodeList);
        if (null != originalCode && CollectionUtils.isNotEmpty(standardCodeList)) {
            LocationFacadeDTO locationDTO;
            String fullCode = originalCode;
            if (12 != fullCode.length() && null == (locationDTO = this.getLocationByCode(fullCode = originalCode + "000000"))) {
                fullCode = originalCode.substring(0, 4) + "00000000";
            }
            if (standardCodeList.contains(fullCode)) {
                return true;
            }
        }
        return false;
    }

    public LocationFacadeDTO getLocationByGeocode(String code) {
        return this.getInternalLocationByGeocode(code);
    }

    @Override
    public CustomerServiceDTO getCustomerServiceInfo(String code) {
        CustomerServiceDTO customerInfoCache = (CustomerServiceDTO)this.redisHashMapAdapter.get(RedisConfig.CUSTOMER_SERVICE_INFO, code, CustomerServiceDTO.class);
        if (null != customerInfoCache) {
            LOG.info("\u4ee5\u5730\u533a\u7f16\u7801:{}\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u7684\u5ba2\u670d\u4fe1\u606f\u4e3a:{}", (Object)code, (Object)JSON.toJSONString((Object)customerInfoCache));
            return customerInfoCache;
        }
        CustomerServiceDTO customerServiceDTO = new CustomerServiceDTO();
        Location location = this.locationMapper.selectByCode(code);
        if (null == location) {
            this.logger.info("\u6839\u636e\u533a\u57df\u7f16\u7801:{}\u83b7\u53d6\u7684\u5730\u533a\u4fe1\u606f\u4e3a\u7a7a,\u8fd4\u56de\u9ed8\u8ba4\u7684\u5ba2\u670d\u4fe1\u606f", (Object)code);
            customerServiceDTO.setCustomerServiceNumber(this.bizConfigProperties.getCustomerServiceNumber());
            return customerServiceDTO;
        }
        if (StringUtils.isBlank((CharSequence)location.getCustomerServiceNumber())) {
            customerServiceDTO.setCustomerServiceNumber(this.bizConfigProperties.getCustomerServiceNumber());
            customerServiceDTO.setCustomerServiceQrCode(location.getCustomerServiceQrCode());
        } else {
            customerServiceDTO.setCustomerServiceNumber(location.getCustomerServiceNumber());
            customerServiceDTO.setCustomerServiceQrCode(location.getCustomerServiceQrCode());
        }
        this.redisHashMapAdapter.put(RedisConfig.CUSTOMER_SERVICE_INFO, code, (Object)customerServiceDTO);
        return customerServiceDTO;
    }

    @Override
    public List<String> listAllLocationWithCommunity() {
        return this.locationMapper.selectLocationWithCommunity();
    }
}

