package com.bxm.localnews.base.config;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/1/24 17:57
 * @desc
 */
@Component
@ConfigurationProperties("client.config")
public class ClientConfigProperties {

    /**
     * 下级页面跳转类型
     */
    private Integer jumpUrlType;

    private Map<String, String> keys = Maps.newHashMap();

    private List<String> merchantCategory = Lists.newArrayList();

    public List<String> getMerchantCategory() {
        return merchantCategory;
    }

    public void setMerchantCategory(List<String> merchantCategory) {
        this.merchantCategory = merchantCategory;
    }

    public Integer getJumpUrlType() {
        return jumpUrlType;
    }

    public void setJumpUrlType(Integer jumpUrlType) {
        this.jumpUrlType = jumpUrlType;
    }

    public Map<String, String> getKeys() {
        return keys;
    }

    public void setKeys(Map<String, String> keys) {
        this.keys = keys;
    }
}
