package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.constant.PublishStateEnum;
import com.bxm.localnews.base.service.AppVersionService;
import com.bxm.localnews.base.service.AppVersionSupplyService;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.vo.BasicParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2018/10/22 10:47
 * @desc
 */
@Service
public class AppVersionSupplyServiceImpl implements AppVersionSupplyService {

    private AppVersionService appVersionService;

    @Autowired
    public AppVersionSupplyServiceImpl(AppVersionService appVersionService) {
        this.appVersionService = appVersionService;
    }

    @Override
    public Boolean getPublishState(BasicParam basicParam) {
        AppVersionDTO appVersionDTO = appVersionService.getAppVersion(basicParam);

        return PublishStateEnum.PURSE.getState().equals(appVersionDTO.getStatus());
    }

    @Override
    public boolean inWhiteList(String phone) {
        return appVersionService.inWhiteList(phone);
    }

    @Override
    public int isHighVersion(String curVer, String version) {
        return appVersionService.isHighVersion(curVer, version);
    }
}
