package com.bxm.localnews.base.service.impl;

import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.base.domain.BuryPointMapper;
import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.vo.BuryPoint;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.gexin.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
@RefreshScope
public class BizLogAsyncSaveServiceImpl extends BaseService implements BizLogAsyncSaveService {

    private HttpClientService httpClientService;

    private BizConfigProperties bizConfigProperties;

    /**
     * 埋点数据接口
     */
    private BuryPointMapper buryPointMapper;

    /**
     * 序列创建服务
     */
    private SequenceCreater sequenceCreater;

    @Autowired
    public BizLogAsyncSaveServiceImpl(HttpClientService httpClientService, BizConfigProperties bizConfigProperties,
                                      BuryPointMapper buryPointMapper, SequenceCreater sequenceCreater) {
        this.httpClientService = httpClientService;
        this.bizConfigProperties = bizConfigProperties;
        this.buryPointMapper = buryPointMapper;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    @Async
    public void save(Map<String, String> data) {
        try {
            httpClientService.doGet(bizConfigProperties.getBizLogUrl(), data);
            saveDB(data);
            //TODO 数据库中埋点
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        }
    }

    /**
     * 埋点数据存入数据库中
     * @param data 埋点数据
     */
    private void saveDB(Map<String, String> data) {

        BuryPoint buryPoint = new BuryPoint();
        buryPoint.setId(sequenceCreater.nextLongId());
        buryPoint.setE(data.get("e"));
        buryPoint.setV(data.get("v"));
        buryPoint.setDtype(data.get("dtype"));
        buryPoint.setTs(data.get("ts"));
        buryPoint.setIp(data.get("ip"));
        buryPoint.setA(data.get("a"));
        buryPoint.setData(JSON.toJSONString(data));

        //插入数据库中
        buryPointMapper.insertSelective(buryPoint);
    }

}
