package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.service.AreaService;
import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.ChannelService;
import com.bxm.localnews.base.vo.BizLogParamBuilder;
import com.bxm.localnews.common.vo.Channel;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service
public class BizLogServiceImpl implements BizLogService {

    private BizLogAsyncSaveService bizLogAsyncSaveService;

    private ChannelService channelService;

    private AreaService areaService;

    @Autowired
    public BizLogServiceImpl(BizLogAsyncSaveService bizLogAsyncSaveService, ChannelService channelService, AreaService areaService) {
        this.bizLogAsyncSaveService = bizLogAsyncSaveService;
        this.channelService = channelService;
        this.areaService = areaService;
    }

    private BizLogParamBuilder build(String event) {
        return BizLogParamBuilder.build(event, bizLogAsyncSaveService);
    }

    private BizLogParamBuilder build(String event, String areaCode) {
        return BizLogParamBuilder.build(event, areaCode, bizLogAsyncSaveService);
    }

    @Override
    public void newUser(Long userId, String channel, String token) {
        //渠道转换,根据编码转换为数据平台需要的结构
        BizLogParamBuilder builder = build("1002").setUid(userId);
        if (StringUtils.isNotBlank(token)) {
            builder.setToken(token);
        }
        Channel channelCode = channelService.getChannelByCode(channel);
        if (channelCode.getId() != null) {
            builder.setSrc(channelCode.getId());
        } else {
            //5表示其他渠道
            builder.setSrc(5L);
        }

        builder.save();
    }

    @Override
    public void login(Long userId) {
        build("1003").setUid(userId).save();
    }

    @Override
    public void changeGender(Long userId, int sex) {
        build("1004").setUid(userId).setEventVal(sex).save();
    }

    @Override
    public void changeArea(Long userId, String areaCode) {
        BizLogParamBuilder builder = build("1005").setUid(userId);
        if (StringUtils.isNotBlank(areaCode)) {
            builder.setEventVal(areaService.getBizLogArea(areaCode));
        }
        builder.setUid(userId).save();
    }

    @Override
    public void scan(int online, String pageSrc, String mid, String areaCode, String ip) {
        build("1008")
                .setOneline(online)
                .setMid(mid)
                .setAreaCode(areaCode)
                .setPageSrc(pageSrc)
                .setIp(ip)
                .save();
    }

    @Override
    public void inviteSuccessed(Long userId, Long invitedUserId) {
        build("2006").setUid(userId).setEventVal(invitedUserId).save();
    }

    @Override
    public void joinPrivilege(Long userId, Long privilegeId) {
        build("3006").setUid(userId).setActivityId(privilegeId).save();
    }

    @Override
    public void invitePrivilege(Long userId, Long invitedUserId, Long privilegeId) {
        build("3009").setUid(userId).setEventVal(invitedUserId).setActivityId(privilegeId).save();
    }

    @Override
    public void baozhiPrivilege(Long privilegeId, String pageSource, Integer isOnline, String ip) {
        build("3011").setPageSource(pageSource).setIsOnline(isOnline).setActivityId(privilegeId).setIp(ip).save();
    }

    @Override
    public void buyVip(Long userId) {
        build("3014").setUid(userId).save();
    }

    @Override
    public void inviteVip(Long userId) {
        build("3024").setUid(userId).save();
    }

    @Override
    public void activateVip(Long userId) {
        build("3025").setUid(userId).save();
    }

    @Override
    public void conformDrawAreaUser(Long userId, String areaCode) {
        build("3028", areaCode).setUid(userId).save();
    }

    @Override
    public void lotteryDraw(Long userId, Integer num, BigDecimal money) {
        build("3029").setUid(userId).setNum(num).setMoney(money).save();
    }

    @Override
    public void initiateWithdrawal(Long userId, BigDecimal money) {
        build("3030").setUid(userId).setMoney(money).save();
    }

    @Override
    public void successWithdrawal(Long userId, BigDecimal money) {
        build("3031").setUid(userId).setMoney(money).save();
    }

    @Override
    public void forumSucceed(Long userId, String areaCode) {
        build("2007", areaCode).setUid(userId).save();

    }

    @Override
    public void replySucceed(Long userId, Long id, Integer type, String areaCode) {

        build("2008", areaCode).setUid(userId).setNid(id).setNType(type).save();
    }

    @Override
    public void shareForumSucceed(Long userId, Long id, String areaCode) {

        build("2009", areaCode).setUid(userId).setNid(id).save();
    }

    @Override
    public void forumLikeSucceed(Long userId, Long id, String areaCode) {

        build("2010", areaCode).setUid(userId).setNid(id).save();
    }
}
