package com.bxm.localnews.base.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author gonzo
 * @date 2020-08-27 13:42
 **/
@Data
@Component
@ConfigurationProperties("base.config.location")
public class LocationProperties {

    /**
     * 特殊地区的强制切换开关 ture: 开启强制切换
     */
    private Boolean specialLocationForceSwitch = Boolean.TRUE;

    /**
     * 特殊地区的切换信息
     */
    private Map<String, String> specialLocationSwitchInfo;

    /**
     * 部分地区未配置分享标题时取默认值；
     */
    private String content = "送你价值299元金华万事通vip卡，领取后享受200+金华特权福利";

    /**
     * 部分地区未配置分享内容描述时取默认值；
     */
    private String contentDesc = "肯德基、外卖红包、星巴克、周黑鸭、视频会员等福利应用尽有" ;

    /**
     * 部分地区未配置分享图片时取默认值；
     */
    private String imgUrl = "https://m.wstong.com/localnews_prod/jpg/20200730/94866SC1H9XHF6D8WVANP3XXFP1O3INXS48DKYB.jpg";

}
