package com.bxm.localnews.base.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 特殊url配置
 * @author gonzo
 * @date 2020-08-03 19:47
 **/
@Data
@Component
@ConfigurationProperties("base.config.special-url")
public class SpecialUrlConfig {

    /**
     * 渠道地址 剔除根路径 h5之后的地址
     */
    private String channel = "/register.html?inviteUserId=";

    /**
     * 下载地址 剔除根路径 h5之后的地址
     */
    private String download = "/download.html";

    /**
     * 好友扫一扫链接地址
     */
    private String friendSweepUrl = "/qrcode.html?inviteUserId=";

    /**
     * 某一个活动
     * 历史遗留
     */
    private String shareDrawActivity = "/shareDrawActivity.html";

    /**
     * 应用图标地址
     */
    private String appIconUrl;

    /**
     * 应用宝下载跳转地址
     */
    private String downloadYYBUrl;
}
