package com.bxm.localnews.base.service;

import com.bxm.localnews.common.dto.EquipmentDTO;
import com.bxm.localnews.common.param.EquipmentParam;

public interface EquipmentService {

    /**
     * 上报设备信息，进行保存之后返回唯一标识
     * @param equipmentParam
     * @return
     */
    String save(EquipmentParam equipmentParam);

    /**
     * 异步保存设备信息
     * @param requestEquipment 请求的设备信息
     * @param existsEquipment  已经存在的设备信息
     */
    void saveWithAsync(EquipmentDTO requestEquipment, EquipmentDTO existsEquipment,EquipmentParam param);

    /**
     * 根据设备号获取设备信息
     * 这个设备号可以是IMEI也可以是android等..
     * @param deviceId
     * @return
     */
    EquipmentDTO getByDeviceId(String deviceId);

    /**
     * 根据设备唯一标识获取设备信息并设置到缓存中
     * @param deviceId
     * @return
     */
    EquipmentDTO get(String deviceId);
}
