package com.bxm.localnews.base.service.domain.joins;

import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.dto.JointerContext;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 默认的拼接器行为
 * join(url) = url/h5/
 * @author gonzo
 * @date 2020-07-30 19:17
 **/
@Component
public class DefaultSceneBaseUrlJointer implements SceneBaseUrlJointer {

    @Override
    public String join(JointerContext context) {
        return StringUtils.join(context.getUrl(), SEG, BASE_H5_URL);
    }

    @Override
    public DomainScene support() {
        // 默认拼接器 不返回具体处理类型
        return null;
    }
}
