package com.bxm.localnews.base.service.domain.mointer;

import com.bxm.localnews.base.service.domain.mointer.heartbeat.DomainHeartbeat;
import com.bxm.localnews.common.constant.DomainScene;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author gonzo
 * @date 2020-09-09 15:09
 **/
@Slf4j
@Service
public class MoniterService {

    private List<DomainHeartbeat> domainHeartbeatList;

    private Map<DomainScene, DomainHeartbeat> domainSceneDomainHeartbeatMap = Maps.newHashMap();

    public MoniterService(List<DomainHeartbeat> domainHeartbeatList) {
        this.domainHeartbeatList = domainHeartbeatList;
    }

    @PostConstruct
    public void init() {
        domainHeartbeatList.forEach(p -> {
            domainSceneDomainHeartbeatMap.put(p.support(), p);
        });
    }

    /**
     * 校验域名是否可用
     * @param baseUrl 带协议和域名的base url
     * @param scene 域名场景
     * @return true: 可用 false 不可用
     */
    public boolean checkBaseUrlAvailable(String baseUrl, DomainScene scene) {
        DomainHeartbeat heartbeat = domainSceneDomainHeartbeatMap.get(scene);
        if (Objects.isNull(heartbeat)) {
            log.warn("域名类型: {} 没有对应的处理类", scene);
            return false;
        }

        return heartbeat.ping(baseUrl);
    }



}
