package com.bxm.localnews.base.service.domain.mointer.heartbeat;

import com.bxm.localnews.common.constant.DomainScene;

/**
 * 域名心跳检测
 *
 * @author gonzo
 * @date 2020-09-09 15:10
 **/
public interface DomainHeartbeat {

    /**
     * 检测是否能够ping 通
     * @param baseUrl 服务器域名 or H5域名的 base url eg: https://webtest.wstong.com/
     * @return true 正常 false验签已掉
     */
    boolean ping(String baseUrl);

    /**
     * 当前检测处理的域名类型
     * @return 域名类型
     */
    DomainScene support();
}
