package com.bxm.localnews.base.service.domain.mointer.ping;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * h5域名检测是否可用
 *
 * @author gonzo
 * @date 2020-09-09 15:32
 **/
@Slf4j
@Service
public class H5Pinner implements Pinner {

    @Override
    public boolean ping(String baseUrl) {
        String heartUrl = StringUtils.join(baseUrl, "/h5/heartbeat/hb.txt");
        log.info("检测H5 base url 是否可用: {}", heartUrl);

        try {
            // 请求一个资源文件 资源文件里面就写着 success
            String result = OkHttpUtils.get(heartUrl);

            return isNotBlank(result) && result.contains("success");
        } catch(Exception e) {
            log.error("校验心跳: {}失败", heartUrl, e);
        }

        return false;
    }
}
