package com.bxm.localnews.base.service.domain.mointer.ping;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Objects;

import static java.util.Objects.nonNull;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * h5域名检测是否可用
 *
 * @author gonzo
 * @date 2020-09-09 15:32
 **/
@Slf4j
@Service
public class ServerPinner implements Pinner {

    @Override
    public boolean ping(String baseUrl) {
        String heartUrl = StringUtils.join(baseUrl, "/api/app/heartbeat");
        log.info("检测服务器base url 是否可用: {}", heartUrl);
        // 检测服务心跳
        try {
            String result = OkHttpUtils.get(heartUrl);

            log.info("检测服务器base url 是否可用返回: {}", result);
            if (isBlank(result)) {
                return false;
            }

            JSONObject jsonObject = JSON.parseObject(result);
            return nonNull(jsonObject) && Objects.equals("OK", jsonObject.getString("result"));
        } catch(Exception e) {
            log.error("校验心跳: {}失败", heartUrl, e);
        }
        return false;
    }
}
