package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.common.dto.BaseDTO;
import com.bxm.localnews.base.service.AreaWhiteBlackService;
import com.bxm.localnews.common.constant.GlobalFlagEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class AreaWhiteBlackServiceImpl implements AreaWhiteBlackService {

    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    public <T extends BaseDTO> List<T> getCacheByAreaCode(String key, String areaCode, TypeReference<List<T>> typeReference) {
        return this.redisHashMapAdapter.get(RedisConfig.AREA_WHITE_BLACK_LIST.copy().appendKey(key), areaCode, typeReference);
    }

    @Override
    public <T extends BaseDTO> List<T> filterCacheByAreaCode(List<T> totalList, List<Long> whiteList, List<Long> blackList) {
        List<T> resultList = new ArrayList<>();
        if (CollectionUtils.isEmpty(totalList)) {
            return totalList;
        }

        totalList.forEach(e -> {
            //若非全球投放，则过滤白名单
            if (GlobalFlagEnum.IS_NOT_GLOBAL.getState().equals(e.getGlobalFlag()) && whiteList != null && whiteList.contains(e.getId())) {
                resultList.add(e);
            }
            //若全球投放，则过滤黑名单
            if (GlobalFlagEnum.IS_GLOBAL.getState().equals(e.getGlobalFlag()) && blackList != null && !blackList.contains(e.getId())) {
                resultList.add(e);
            }
        });

        return resultList;
    }

    @Override
    public <T extends BaseDTO> void setCacheByAreaCode(String key, String areaCode, List<T> dataList) {
        if (!CollectionUtils.isEmpty(dataList)) {
            this.redisHashMapAdapter.put(RedisConfig.AREA_WHITE_BLACK_LIST.copy().appendKey(key), areaCode, dataList);
        }
    }
}
