package com.bxm.localnews.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.config.DomainConfig;
import com.bxm.localnews.base.service.ClientConfigService;
import com.bxm.localnews.common.config.ClientConfigProperties;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.param.DomainInfoParam;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;
import com.bxm.localnews.common.vo.BaseUrlInfo;
import com.bxm.localnews.common.vo.PreloadingH5;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import static com.alibaba.fastjson.JSON.parseArray;
import static com.alibaba.fastjson.JSON.toJSONString;
import static java.util.Objects.isNull;
import static org.apache.commons.lang3.StringUtils.*;

/**
 * @author zhaoyadong 2019/1/24 18:01
 * @desc
 */
@Slf4j
@Service
public class ClientConfigServiceImpl implements ClientConfigService {

    @Autowired
    private ClientConfigProperties clientConfigProperties;

    @Autowired
    private DomainConfig domainConfig;

    @Autowired
    private BaseUrlService baseUrlService;

    @Autowired
    private SequenceCreater sequenceCreater;

    @Autowired
    private MessageSender messageSender;

    @Override
    public Integer getJumpUrlType() {
        return clientConfigProperties.getJumpUrlType();
    }

    @Override
    public String getValueByKey(String key) {
        return clientConfigProperties.getKeys().get(key);
    }

    @Override
    public List<String> listMerchantCategory() {
        return clientConfigProperties.getMerchantCategory();
    }

    @Override
    public Map<String, String> getAllConfig(Integer platform) {
        Map<String, String> commonMap;
        commonMap = clientConfigProperties.getCommonKeys();

        Map<String, String> specialMap;
        if (platform == 1) {
            specialMap = clientConfigProperties.getAndroidKeys();
        } else if (platform == 2) {
            specialMap = clientConfigProperties.getIosKeys();
        } else if (platform == 3) {
            specialMap = clientConfigProperties.getWebKeys();
        } else if (platform == 5) {
            specialMap = clientConfigProperties.getAppletKeys();
        } else {
            specialMap = clientConfigProperties.getKeys();
        }
        Map<String, String> resultMap = new HashMap<>(commonMap);
        resultMap.putAll(specialMap);

        // 处理base url的替换
        replaceBaseUrl(resultMap);
        return resultMap;
    }

    private void replaceBaseUrl(Map<String, String> resultMap) {
        DomainInfoParam param = new DomainInfoParam();
        param.setScene(Objects.toString(DomainScene.INNER_H5));
        String baseH5UrlBySceneF = getBaseH5UrlByScene(param);

        if (isBlank(baseH5UrlBySceneF)) {
            log.warn("没有可用的站内H5域名，选用默认配置的，请及时配置");
            baseH5UrlBySceneF = domainConfig.getDefaultInnerH5BaseUrl();
        }

        String baseH5UrlByScene = baseH5UrlBySceneF;
        // 站内的H5 base url
        if (isNotBlank(resultMap.get("h5Server")) && isNotBlank(baseH5UrlByScene)) {
            // 替换原有的h5Server
            resultMap.put("h5Server", baseH5UrlByScene);
        }

        // 预加载的base url替换
        String preloadingH5;
        if (isNotBlank(preloadingH5 = resultMap.get("preloadingH5"))) {
            List<PreloadingH5> preloadingH5s = parseArray(preloadingH5, PreloadingH5.class);
            if (!CollectionUtils.isEmpty(preloadingH5s) && isNotBlank(baseH5UrlByScene)) {
                // 每一个preloading 都进行拼接
                preloadingH5s.forEach(p -> {
                    if (isNotBlank(p.getPath())) {
                        p.setUrl(join(baseH5UrlByScene, p.getPath()));
                        p.setPath(null);
                    }
                });
                resultMap.put("preloadingH5", JSON.toJSONString(preloadingH5s));
            }
        }
    }

    @Override
    public String getBaseH5UrlByScene(DomainInfoParam param) {
        GetAvailableDomainInfoParam infoParam = new GetAvailableDomainInfoParam();
        infoParam.merge(param);
        infoParam.setScene(param.getScene());
        infoParam.setViewScene(param.getViewScene());

        // 老版本的客户端请求如果为空 则表示是客户端请求获取分享url 这里手动指定一下
        if (isBlank(infoParam.getScene())) {
            // 设置域名场景
            infoParam.setScene(Objects.toString(DomainScene.OUTSIDE_SHARE));
            // 设置落地页场景 这里默认指定为内容
            infoParam.setViewScene(Objects.toString(DomainScene.DomainViewScene.CONTENT_VIEW));
        }

        BaseUrlInfo baseUrlInfo = baseUrlService.getBaseUrlInfo(infoParam);
        if (isNull(baseUrlInfo) || isBlank(baseUrlInfo.getBaseUrl())) {
            // 这个是是在没办法的办法了
            // 发送叮叮消息
            String msg = String.format("【紧急】获取h5的base url失败！！！！！请及时关注，贼重要！！！！！事件id: %s ", sequenceCreater.nextStringId());
            messageSender.sendDingtalk(DingtalkMessage.builder()
                    .content(msg)
                    .build());
            log.warn(msg + "param: {}", toJSONString(param));
            return "https://web.wstong.com/h5/";
        }
        return baseUrlInfo.getBaseUrl();
    }
}
