package com.bxm.localnews.base.service.webtoken;

import com.bxm.localnews.common.vo.WebTokenVerifyVO;
import com.bxm.newidea.component.vo.Message;

/**
 * 获取站外WEB TOKEN服务接口
 *
 * @author wzy
 * @version 1.0
 * @date 2021/1/14 11:41 上午
 */
public interface WebTokenService {

    /**
     * 获取webToken
     *
     * @param code 微信静默授权code码
     * @return webToken
     */
    Message getWebToken(String code);

    /**
     * 验证web Token是否合法
     *
     * @param token webToken
     * @return 是否合法
     */
    WebTokenVerifyVO verifyWebToken(String token);
}