package com.bxm.localnews.base.timer;

import com.bxm.localnews.base.config.DomainConfig;
import com.bxm.localnews.base.service.manage.DomainManageService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 域名检测定时任务
 *
 * @author gonzo
 * @date 2020-09-09 16:46:29
 **/
@Component
@Slf4j
@AllArgsConstructor
public class DomainMoniterAcquireTask extends AbstractCronTask<String> {

    private final DomainManageService domainManageService;

    private final DomainConfig domainConfig;

    @Override
    protected ReturnT<String> service(String s) {
        try {
            if (Objects.equals(domainConfig.getMointerSwitch(), Boolean.TRUE)) {
                domainManageService.scheduleCheckDomain();
            }

            return ReturnT.FAIL;
        } catch (Exception e) {
            log.error("域名检测定时任务失败", e);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "域名检测定时任务";
    }

    @Override
    public String cron() {
        return "0 */1 * * * ?";
    }

    @Override
    public String description() {
        return "每分钟域名检测定时任务";
    }
}
