package com.bxm.localnews.base.service;

import com.bxm.localnews.common.dto.LocationSwitchDTO;
import com.bxm.localnews.common.param.GetAreaInfoParam;
import com.bxm.localnews.common.param.LocationSwitchParam;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.localnews.common.vo.BasicParam;

public interface AreaInfoService {

    /**
     * 根据城市编码获取城市信息
     * 查询不到会查询上级，再查询不到会返回默认城市信息
     * @see #getAreaInfo(GetAreaInfoParam, boolean, boolean);
     * @param code 城市编码
     * @param basicParam 基础参数
     * @return
     */
    AreaInfo getAreaInfo(String code, BasicParam basicParam);

    /**
     * 根据城市编码获取城市信息
     * 如果是3.3.1版本之后，在用户登录后，设置基本信息的地方，根据定位获取到的code到后端获取城市信息获取不到的情况下不查询上一级，也不返回默认城市信息
     * @param param 请求参数
     * @param defaultInfo 是否返回默认信息 true: 根据code肯定会有一个默认城市返回 false: 查询不到就返回空信息
     * @param lastCodeQuery 是否使用code查询最新编码 客户端带过来的code为最新行政编码所以需要设置为true
     * @return
     */
    AreaInfo getAreaInfo(GetAreaInfoParam param, boolean defaultInfo, boolean lastCodeQuery);

    /**
     * 根据客户端上报的客户端本地存储code和第三方获取到的定位code，进行用户最终定位的获取
     * 如果用户属于强制切换列表中，则返回强制切换的信息
     * 如果用户上一次的定位code不为空，则直接返回上一次的定位code，强制切换
     * 如果数据库存储的用户定位信息为空，则根据第三方code进行获取城市信息，获取到则返回信息，强制切换
     * @param param 获取需要切换的城市参数
     * @return 切换城市的信息 是否强制切换
     */
    LocationSwitchDTO locationSwitch(LocationSwitchParam param);
}
