package com.bxm.localnews.base.service;

import java.util.List;
import java.util.Map;

import com.bxm.localnews.common.dto.ChannelDTO;
import com.bxm.localnews.common.vo.Channel;

import org.springframework.stereotype.Component;

/**
 * Created by Administrator on 2017/12/23.
 */

@Component
public interface ChannelService {

    List<ChannelDTO> listChannel(Map<String, Object> searchMap, int current, int pageSize);

    /**
     * 通过渠道码获取渠道信息
     * @param code
     * @return
     */
    Channel getChannelByCode(String code);

    /**
     * 推送渠道邀请信息
     * @param userId
     * @param channel
     * @param inviterCode
     */
    void pushChannelInviterInfo(Long userId, String channel, Long inviterCode);
}
