package com.bxm.localnews.base.service.domain.joins;

import com.bxm.localnews.common.dto.JointerContext;
import org.apache.commons.lang3.StringUtils;

/**
 * 默认的什么都不做处理的连接器
 * 有些域名确实不需要做处理，比如短链的域名，是网关做处理，就不需要拼接啥了
 * @author gonzo
 * @date 2020-08-03 18:58
 **/
public abstract class AbstractDefaultWithoutJoinJointer implements SceneBaseUrlJointer {

    @Override
    public String join(JointerContext context) {
        // 不做处理 直接返回
        return StringUtils.join(context.getUrl(), SEG);
    }

}
