package com.bxm.localnews.base.service.domain.joins;

import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.dto.JointerContext;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 站外分享的base url
 * 根据场景值进行拼接的h5 base url
 * https://domain/s/{scene}/h5/
 * 网关层会截取场景，根据场景获取域名，进行重定向
 * @author gonzo
 * @date 2020-07-31 20:19
 **/
@Component
public class ViewSceneBaseUrlJointer implements SceneBaseUrlJointer {

    private static final String GATE_WAY_PATH = "/s/";

    @Override
    public String join(JointerContext context) {
        return StringUtils.join(context.getUrl(), GATE_WAY_PATH, Objects.toString(context.getDomainViewScene()), SEG, BASE_H5_URL);
    }

    @Override
    public DomainScene support() {
        return DomainScene.OUTSIDE_SHARE;
    }
}
