package com.bxm.localnews.base.service.manage;

import com.bxm.localnews.base.domain.WechatMpInfoExtendMapper;
import com.bxm.localnews.common.entity.WechatMpInfo;
import com.bxm.localnews.common.vo.WechatMpInfoVO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author gonzo
 * @date 2020-10-30 11:31
 **/
@Slf4j
@Service
@AllArgsConstructor
public class WechatMpManageServiceImpl implements WechatMpManageService {

    private final WechatMpInfoExtendMapper wechatMpInfoExtendMapper;


    @Override
    public List<WechatMpInfoVO> listAllEnable() {
        return wechatMpInfoExtendMapper.listAllEnable().stream().map(this::convert).collect(Collectors.toList());
    }

    private WechatMpInfoVO convert(WechatMpInfo wechatMpInfo) {
        WechatMpInfoVO infoVO = new WechatMpInfoVO();
        BeanUtils.copyProperties(wechatMpInfo, infoVO);
        return infoVO;
    }

}
