/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.AppVersionMapper;
import com.bxm.localnews.base.service.AppVersionService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.PublishStateEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.constant.VersionForceEnum;
import com.bxm.localnews.common.dto.AppVersionDTO;
import com.bxm.localnews.common.util.IPUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.IP;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class AppVersionServiceImpl
extends BaseService
implements AppVersionService {
    private AppVersionMapper appVersionMapper;
    private BizConfigProperties bizConfigProperties;
    private RedisStringAdapter redisStringAdapter;
    private RedisHashMapAdapter redisHashMapAdapter;
    private IPUtil ipUtil;
    private LoadingCache<String, List<AppVersionDTO>> cache;

    @Autowired
    public AppVersionServiceImpl(AppVersionMapper appVersionMapper, BizConfigProperties bizConfigProperties, RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, IPUtil ipUtil) {
        this.appVersionMapper = appVersionMapper;
        this.bizConfigProperties = bizConfigProperties;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.ipUtil = ipUtil;
        this.initCache();
    }

    private Boolean isAbroadOfCountry(String ip) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ip})) {
            Boolean isAbroadCountry = (Boolean)this.redisHashMapAdapter.get(this.getCountryKey(), ip, Boolean.class);
            if (isAbroadCountry == null) {
                isAbroadCountry = Boolean.FALSE;
                IP i = this.ipUtil.find(ip);
                if (i == null || i.getCountry() == null) {
                    isAbroadCountry = Boolean.FALSE;
                } else if ("\u7f8e\u56fd".equals(i.getCountry())) {
                    isAbroadCountry = Boolean.TRUE;
                    this.redisHashMapAdapter.put(this.getCountryKey(), ip, (Object)Boolean.TRUE);
                }
            }
            return isAbroadCountry;
        }
        return true;
    }

    private KeyGenerator getCountryKey() {
        return RedisConfig.BASE_IP.copy().appendKey((Object)"list");
    }

    @Override
    public boolean inWhiteList(String phone) {
        return this.bizConfigProperties.getWhiteList().contains(phone);
    }

    @Override
    public AppVersionDTO getAppVersion(BasicParam basicParam) {
        String combineChannel = basicParam.getPlatform() + basicParam.getChnl();
        List filterVersionList = (List)this.cache.getUnchecked((Object)combineChannel);
        String curVer = basicParam.getCurVer();
        AppVersionDTO appVersionDTO = new AppVersionDTO();
        appVersionDTO.setMobileType(Integer.valueOf(basicParam.getPlatform()));
        appVersionDTO.setCode(basicParam.getChnl());
        appVersionDTO.setVersion(curVer);
        appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
        if (CollectionUtils.isEmpty((Collection)filterVersionList)) {
            return appVersionDTO;
        }
        appVersionDTO = this.getLastVersionClone(filterVersionList);
        if (this.isHighVersion(curVer, appVersionDTO.getVersion()) != -1) {
            appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
            return appVersionDTO;
        }
        List<AppVersionDTO> enableHigherVersionList = filterVersionList.stream().filter(app -> app.getEnable() == 1).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(enableHigherVersionList)) {
            appVersionDTO.setVersion(curVer);
            appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
            return appVersionDTO;
        }
        appVersionDTO = this.getLastVersionClone(enableHigherVersionList);
        if (this.isHighVersion(curVer, appVersionDTO.getVersion()) != -1) {
            appVersionDTO.setVersion(curVer);
            appVersionDTO.setIsForce(VersionForceEnum.NOT_UPDATE.getState());
            return appVersionDTO;
        }
        Byte updateType = this.getUpdateType(curVer, enableHigherVersionList);
        appVersionDTO.setIsForce(updateType);
        return appVersionDTO;
    }

    private Byte getUpdateType(String curVer, List<AppVersionDTO> enableHigherVersionList) {
        Byte updateType = enableHigherVersionList.get(0).getIsForce();
        for (AppVersionDTO appVersionDTO : enableHigherVersionList) {
            if (StringUtils.compareVersion((String)appVersionDTO.getVersion(), (String)curVer) <= 0) break;
            if (!Objects.equals(VersionForceEnum.FORCE_UPDATE.getState(), appVersionDTO.getIsForce())) continue;
            updateType = appVersionDTO.getIsForce();
            break;
        }
        return updateType;
    }

    private AppVersionDTO getLastVersionClone(List<AppVersionDTO> appVersionList) {
        AppVersionDTO appVersionDTO = appVersionList.get(0);
        AppVersionDTO cloneVersionDTO = new AppVersionDTO();
        BeanUtils.copyProperties((Object)appVersionDTO, (Object)cloneVersionDTO);
        return cloneVersionDTO;
    }

    @Override
    public AppVersionDTO getAppVersion(BasicParam basicParam, String ip) {
        AppVersionDTO appVersionDTO = this.getAppVersion(basicParam);
        if (3 == basicParam.getPlatform()) {
            appVersionDTO.setStatus(PublishStateEnum.NORMAL.getState());
            return appVersionDTO;
        }
        if (2 == basicParam.getPlatform() && PublishStateEnum.NORMAL.getState().equals(appVersionDTO.getStatus()) && this.isAbroadOfCountry(ip).booleanValue()) {
            appVersionDTO.setStatus(PublishStateEnum.PURSE.getState());
        }
        return appVersionDTO;
    }

    private List<AppVersionDTO> getAllAppVersion(String platformAndChannel) {
        TypeReference<List<AppVersionDTO>> typeReference = new TypeReference<List<AppVersionDTO>>(){};
        List appVersionList = (List)this.redisStringAdapter.get(this.getAppChannelListKey(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)appVersionList)) {
            appVersionList = this.appVersionMapper.getAllAppVersion();
            this.redisStringAdapter.set(this.getAppChannelListKey(), (Object)appVersionList);
        }
        List<Object> result = Lists.newArrayList();
        for (AppVersionDTO appVersionDTO : appVersionList) {
            String combineChannel = appVersionDTO.getMobileType() + appVersionDTO.getCode();
            if (!StringUtils.equals((CharSequence)combineChannel, (CharSequence)platformAndChannel)) continue;
            result.add(appVersionDTO);
        }
        result = result.stream().sorted((v1, v2) -> -StringUtils.compareVersion((String)v1.getVersion(), (String)v2.getVersion())).collect(Collectors.toList());
        return result;
    }

    private void initCache() {
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, List<AppVersionDTO>>(){

            public List<AppVersionDTO> load(String key) throws Exception {
                return AppVersionServiceImpl.this.getAllAppVersion(key);
            }
        });
    }

    private KeyGenerator getAppChannelListKey() {
        return RedisConfig.BASE_APPVERSION_CHANNEL.copy().appendKey((Object)"list");
    }

    @Override
    public int isHighVersion(String curVersion, String version) {
        if (curVersion == null && version != null) {
            return -1;
        }
        if (curVersion != null && version == null) {
            return 1;
        }
        if (StringUtils.equals((CharSequence)curVersion, (CharSequence)version)) {
            return 0;
        }
        return StringUtils.compareVersion((String)curVersion, (String)version);
    }
}

