/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.config.LocationProperties;
import com.bxm.localnews.base.domain.AreaInfoMapper;
import com.bxm.localnews.base.service.AreaInfoService;
import com.bxm.localnews.base.service.LocationService;
import com.bxm.localnews.common.config.BizConfigProperties;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.LocationDetailDTO;
import com.bxm.localnews.common.dto.LocationSwitchDTO;
import com.bxm.localnews.common.dto.UserForceChange;
import com.bxm.localnews.common.param.GetAreaInfoParam;
import com.bxm.localnews.common.param.LocationSwitchParam;
import com.bxm.localnews.common.vo.AreaInfo;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.UserLocationInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AreaInfoServiceImpl
extends BaseService
implements AreaInfoService {
    private static final Logger log = LoggerFactory.getLogger(AreaInfoServiceImpl.class);
    private final AreaInfoMapper areaInfoMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final BizConfigProperties bizConfigProperties;
    private final LocationService locationService;
    private final LocationProperties locationProperties;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserIntegrationService userIntegrationService;

    @Override
    public AreaInfo getAreaInfo(String code, BasicParam basicParam) {
        GetAreaInfoParam param = new GetAreaInfoParam();
        BeanUtils.copyProperties((Object)basicParam, (Object)param);
        param.setCode(code);
        return this.getAreaInfo(param, true, true);
    }

    @Override
    public AreaInfo getAreaInfo(GetAreaInfoParam param, boolean defaultInfo, boolean lastCodeQuery) {
        if (StringUtils.isBlank((CharSequence)param.getCode())) {
            this.logger.error("\u7528\u6237\u83b7\u53d6\u5b9a\u4f4d\u4f20\u53c2\u9519\u8bef,code:[{}],\u53c2\u6570:[{}]", (Object)param.getCode(), JSON.toJSON((Object)param));
            return new AreaInfo();
        }
        String processedCode = this.temporaryProcess(param.getCode(), param.getUserId(), param.getDevcId());
        LocationDetailDTO locationDTO = defaultInfo ? this.locationService.getInternalLocationByGeocode(processedCode, (BasicParam)param) : this.locationService.getInternalLocationByGeocode(processedCode, (BasicParam)param, false, false, lastCodeQuery);
        if (Objects.isNull(locationDTO)) {
            return new AreaInfo();
        }
        processedCode = locationDTO.getCode();
        KeyGenerator areaInfoKey = RedisConfig.AREA_INFO;
        TypeReference<List<AreaInfo>> areaInfoTypeReference = new TypeReference<List<AreaInfo>>(){};
        AreaInfo areaInfo = null;
        List areaInfoList = (List)this.redisStringAdapter.get(areaInfoKey, (TypeReference)areaInfoTypeReference);
        if (areaInfoList != null) {
            String finalCode = processedCode;
            Optional<AreaInfo> areaInfoOptional = areaInfoList.stream().filter(x -> x.getCode().equals(finalCode)).findFirst();
            if (areaInfoOptional.isPresent()) {
                areaInfo = areaInfoOptional.get();
            }
        }
        if (null == areaInfo) {
            areaInfoList = this.areaInfoMapper.selectByModel(null);
            this.redisStringAdapter.set(areaInfoKey, (Object)areaInfoList);
            areaInfo = this.areaInfoMapper.selectByCode(processedCode);
        }
        if (null == areaInfo) {
            areaInfo = new AreaInfo();
        }
        areaInfo.setCode(processedCode);
        areaInfo.setName(locationDTO.getName());
        areaInfo.setEnablePaidPromote(locationDTO.getEnablePaidPromote());
        this.logger.info("\u6839\u636ecode: {} \u83b7\u53d6\u7528\u6237\u5b9a\u4f4d\u4fe1\u606f, \u6700\u7ec8\u83b7\u53d6\u5230\u7684\u5b9a\u4f4d\u4fe1\u606f: {}, \u8bf7\u6c42\u53c2\u6570\u4fe1\u606f: {} ", new Object[]{param.getCode(), JSON.toJSON((Object)areaInfo), JSON.toJSON((Object)param)});
        return areaInfo;
    }

    @Override
    public LocationSwitchDTO locationSwitch(LocationSwitchParam param) {
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237: {} \u83b7\u53d6\u5b9a\u4f4d\u4fe1\u606f\u7684\u8bf7\u6c42\u53c2\u6570: {}", (Object)param.getUserId(), (Object)com.gexin.fastjson.JSON.toJSONString((Object)param));
        }
        LocationSwitchDTO switchDTO = new LocationSwitchDTO();
        AreaInfo areaInfo = new AreaInfo();
        UserLocationInfoDTO userLocationCodeById = this.userIntegrationService.getUserLocationCodeById(param.getUserId());
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237: {} \u7684\u6700\u540e\u4e00\u6b21\u5b9a\u4f4d\u4fe1\u606f: {}", (Object)param.getUserId(), (Object)com.gexin.fastjson.JSON.toJSONString((Object)userLocationCodeById));
        }
        if (Objects.isNull(userLocationCodeById) || StringUtils.isBlank((CharSequence)userLocationCodeById.getLocationCode())) {
            return this.switchFromCode(param);
        }
        LocationDetailDTO locationDTO = this.locationService.getInternalLocationByGeocode(userLocationCodeById.getLocationCode(), (BasicParam)param);
        locationDTO = this.processSpecialUser(param.getUserId(), locationDTO, (BasicParam)param);
        if (Objects.isNull(locationDTO = this.forceSwitchIfNecessary(locationDTO, param)) || StringUtils.isBlank((CharSequence)locationDTO.getCode())) {
            if (StringUtils.isBlank((CharSequence)param.getThirdpartyCode())) {
                this.logger.warn("\u7528\u6237\u83b7\u53d6\u5b9a\u4f4d\u4f20\u53c2\u9519\u8bef, param: {}", JSON.toJSON((Object)param));
                return this.openSwitchReturn(param);
            }
            locationDTO = this.locationService.getInternalLocationByGeocode(this.temporaryProcess(param.getThirdpartyCode(), param.getUserId(), param.getDevcId()), (BasicParam)param);
            if (Objects.isNull(locationDTO) || StringUtils.isBlank((CharSequence)locationDTO.getCode())) {
                return this.openSwitchReturn(param);
            }
        }
        areaInfo.setCode(locationDTO.getCode());
        areaInfo.setName(locationDTO.getName());
        switchDTO.setSwitchType(Byte.valueOf((byte)1));
        switchDTO.setAreaInfo(areaInfo);
        return this.logFinalInfo(switchDTO, param);
    }

    private LocationSwitchDTO switchFromCode(LocationSwitchParam param) {
        LocationSwitchDTO switchDTO = new LocationSwitchDTO();
        AreaInfo areaInfo = new AreaInfo();
        if (StringUtils.isBlank((CharSequence)param.getThirdpartyCode())) {
            this.logger.warn("\u7528\u6237\u83b7\u53d6\u5b9a\u4f4d\u4f20\u53c2\u9519\u8bef, param: {}", JSON.toJSON((Object)param));
            return this.openSwitchReturn(param);
        }
        LocationDetailDTO locationDTO = this.locationService.getInternalLocationByGeocode(this.temporaryProcess(param.getThirdpartyCode(), param.getUserId(), param.getDevcId()), (BasicParam)param);
        if (Objects.isNull(locationDTO) || StringUtils.isBlank((CharSequence)locationDTO.getCode())) {
            return this.openSwitchReturn(param);
        }
        areaInfo.setCode(locationDTO.getCode());
        areaInfo.setName(locationDTO.getName());
        switchDTO.setSwitchType(Byte.valueOf((byte)1));
        switchDTO.setAreaInfo(areaInfo);
        return this.logFinalInfo(switchDTO, param);
    }

    private LocationSwitchDTO openSwitchReturn(LocationSwitchParam param) {
        LocationSwitchDTO switchDTO = new LocationSwitchDTO();
        switchDTO.setSwitchType(Byte.valueOf((byte)0));
        switchDTO.setAreaInfo(null);
        return this.logFinalInfo(switchDTO, param);
    }

    private LocationDetailDTO forceSwitchIfNecessary(LocationDetailDTO locationDTO, LocationSwitchParam param) {
        String specialSwitch;
        if (Objects.equals(this.locationProperties.getSpecialLocationForceSwitch(), Boolean.TRUE) && Objects.nonNull(locationDTO) && StringUtils.isNotBlank((CharSequence)locationDTO.getCode()) && Objects.nonNull(this.locationProperties.getSpecialLocationSwitchInfo()) && StringUtils.isNotBlank((CharSequence)(specialSwitch = this.locationProperties.getSpecialLocationSwitchInfo().get(locationDTO.getCode())))) {
            log.info("\u7528\u6237: {} \u83b7\u53d6\u5230\u7684\u5b9a\u4f4dcode: {} \u5f3a\u5236\u5207\u6362\u5230: {}", new Object[]{param.getUserId(), locationDTO.getCode(), specialSwitch});
            return this.locationService.getInternalLocationByGeocode(specialSwitch, (BasicParam)param);
        }
        return locationDTO;
    }

    private LocationSwitchDTO logFinalInfo(LocationSwitchDTO switchDTO, LocationSwitchParam param) {
        log.info("\u7528\u6237: {} \u8bf7\u6c42\u53c2\u6570: {} \u6700\u7ec8\u83b7\u53d6\u5230\u7684\u5b9a\u4f4d\u4fe1\u606f\u4e3a: {}", new Object[]{param.getUserId(), com.gexin.fastjson.JSON.toJSONString((Object)param), com.gexin.fastjson.JSON.toJSONString((Object)switchDTO)});
        return switchDTO;
    }

    private String temporaryProcess(String code, Long userId, String deviceId) {
        if (Objects.equals(this.bizConfigProperties.getCodeProcessSwitch(), Boolean.FALSE)) {
            return code;
        }
        if (code.startsWith("3301")) {
            this.logger.info("\u7528\u6237: {} \u8bbe\u5907: {} code: {} \u5b9a\u4f4d\u7684\u7279\u6b8a\u5904\u7406\u4e3a\u676d\u5dde", new Object[]{userId, deviceId, code});
            return "330100000000";
        }
        if (code.startsWith("3418") || code.startsWith("341800")) {
            this.logger.info("\u7528\u6237: {} \u8bbe\u5907: {} code: {} \u5b9a\u4f4d\u7684\u7279\u6b8a\u5904\u7406\u4e3a\u5e7f\u5fb7", new Object[]{userId, deviceId, code});
            return "341822000000";
        }
        return code;
    }

    private LocationDetailDTO processSpecialUser(Long userId, LocationDetailDTO locationDTO, BasicParam basicParam) {
        if (Objects.isNull(locationDTO)) {
            return null;
        }
        UserForceChange forceChange = (UserForceChange)this.redisHashMapAdapter.get(RedisConfig.FORCE_CHANGE_USER_AREA_INFO, Objects.toString(userId), UserForceChange.class);
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237: {} \u539f\u672c\u7684\u5b9a\u4f4dcode: {} \u83b7\u53d6\u5230\u7684\u5f3a\u5236\u5207\u6362\u4fe1\u606f\u4e3a: {}", new Object[]{userId, locationDTO.getCode(), com.gexin.fastjson.JSON.toJSONString((Object)forceChange)});
        }
        if (Objects.isNull(forceChange) || !Objects.equals(forceChange.getIfFromCode(), locationDTO.getCode()) || Objects.equals(forceChange.getChanged(), 1)) {
            return locationDTO;
        }
        log.info("\u7528\u6237: {}\u7b26\u5408\u5f3a\u5236\u5207\u6362\u7684\u5224\u65ad\uff0c\u5c06\u5b9a\u4f4d: {} \u5207\u6362\u5230: {}", new Object[]{userId, locationDTO.getCode(), forceChange.getThenChangeCode()});
        return this.locationService.getInternalLocationByGeocode(forceChange.getThenChangeCode(), basicParam);
    }

    public AreaInfoServiceImpl(AreaInfoMapper areaInfoMapper, RedisStringAdapter redisStringAdapter, BizConfigProperties bizConfigProperties, LocationService locationService, LocationProperties locationProperties, RedisHashMapAdapter redisHashMapAdapter, UserIntegrationService userIntegrationService) {
        this.areaInfoMapper = areaInfoMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.bizConfigProperties = bizConfigProperties;
        this.locationService = locationService;
        this.locationProperties = locationProperties;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userIntegrationService = userIntegrationService;
    }
}

