/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.service.AreaWhiteBlackService;
import com.bxm.localnews.common.constant.GlobalFlagEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.BaseDTO;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AreaWhiteBlackServiceImpl
implements AreaWhiteBlackService {
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    public <T extends BaseDTO> List<T> getCacheByAreaCode(String key, String areaCode, TypeReference<List<T>> typeReference) {
        return (List)this.redisHashMapAdapter.get(RedisConfig.AREA_WHITE_BLACK_LIST.copy().appendKey((Object)key), areaCode, typeReference);
    }

    public <T extends BaseDTO> List<T> filterCacheByAreaCode(List<T> totalList, List<Long> whiteList, List<Long> blackList) {
        ArrayList resultList = new ArrayList();
        if (CollectionUtils.isEmpty(totalList)) {
            return totalList;
        }
        totalList.forEach(e -> {
            if (GlobalFlagEnum.IS_NOT_GLOBAL.getState().equals(e.getGlobalFlag()) && whiteList != null && whiteList.contains(e.getId())) {
                resultList.add(e);
            }
            if (GlobalFlagEnum.IS_GLOBAL.getState().equals(e.getGlobalFlag()) && blackList != null && !blackList.contains(e.getId())) {
                resultList.add(e);
            }
        });
        return resultList;
    }

    public <T extends BaseDTO> void setCacheByAreaCode(String key, String areaCode, List<T> dataList) {
        if (!CollectionUtils.isEmpty(dataList)) {
            this.redisHashMapAdapter.put(RedisConfig.AREA_WHITE_BLACK_LIST.copy().appendKey((Object)key), areaCode, dataList);
        }
    }
}

