/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.service.AreaService;
import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.bxm.localnews.base.service.BizLogService;
import com.bxm.localnews.base.service.ChannelService;
import com.bxm.localnews.base.vo.BizLogParamBuilder;
import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.common.vo.Channel;
import com.bxm.newidea.component.tools.StringUtils;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizLogServiceImpl
implements BizLogService {
    private BizLogAsyncSaveService bizLogAsyncSaveService;
    private ChannelService channelService;
    private AreaService areaService;

    @Autowired
    public BizLogServiceImpl(BizLogAsyncSaveService bizLogAsyncSaveService, ChannelService channelService, AreaService areaService) {
        this.bizLogAsyncSaveService = bizLogAsyncSaveService;
        this.channelService = channelService;
        this.areaService = areaService;
    }

    private BizLogParamBuilder build(String event) {
        return BizLogParamBuilder.build(event, this.bizLogAsyncSaveService);
    }

    private BizLogParamBuilder build(String event, String areaCode) {
        return BizLogParamBuilder.build(event, areaCode, this.bizLogAsyncSaveService);
    }

    public void newUser(Long userId, String channel, String token, BigDecimal amount, String registerChannel, String rid, Integer platform) {
        Channel channelCode;
        BizLogParamBuilder builder = this.build("1002").setUid(userId).setMoney(amount).setEventVal(registerChannel).setRid(rid).setDtype(platform);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            builder.setToken(token);
        }
        if ((channelCode = this.channelService.getChannelByCode(channel)).getId() != null) {
            builder.setSrc(channelCode.getId());
        } else {
            builder.setSrc(5L);
        }
        builder.save();
    }

    public void login(Long userId, Integer platform) {
        this.build("1003").setUid(userId).setDtype(platform).save();
    }

    public void changeGender(Long userId, int sex, Integer platform) {
        this.build("1004").setUid(userId).setEventVal(sex).setDtype(platform).save();
    }

    public void changeArea(Long userId, String areaCode, Integer platform) {
        BizLogParamBuilder builder = this.build("1005").setUid(userId).setDtype(platform);
        if (StringUtils.isNotBlank((CharSequence)areaCode)) {
            builder.setEventVal(this.areaService.getBizLogArea(areaCode));
        }
        builder.setUid(userId).save();
    }

    public void scan(int online, String pageSrc, String mid, String areaCode, String ip) {
        this.build("1008").setOneline(online).setMid(mid).setAreaCode(areaCode).setPageSrc(pageSrc).setIp(ip).save();
    }

    public void inviteSuccessed(Long userId, Long invitedUserId, Integer platform) {
        this.build("2006").setUid(userId).setEventVal(invitedUserId).setDtype(platform).save();
    }

    public void joinPrivilege(Long userId, Long privilegeId) {
        this.build("3006").setUid(userId).setActivityId(privilegeId).save();
    }

    public void invitePrivilege(Long userId, Long invitedUserId, Long privilegeId) {
        this.build("3009").setUid(userId).setEventVal(invitedUserId).setActivityId(privilegeId).save();
    }

    public void baozhiPrivilege(Long privilegeId, String pageSource, Integer isOnline, String ip) {
        this.build("3011").setPageSource(pageSource).setIsOnline(isOnline).setActivityId(privilegeId).setIp(ip).save();
    }

    public void buyVip(Long userId) {
        this.build("3014").setUid(userId).save();
    }

    public void inviteVip(Long userId, Integer platform) {
        this.build("3024").setUid(userId).setDtype(platform).save();
    }

    public void activateVip(Long userId, Integer platform) {
        this.build("3025").setUid(userId).setDtype(platform).save();
    }

    public void conformDrawAreaUser(Long userId, String areaCode) {
        this.build("3028", areaCode).setUid(userId).save();
    }

    public void lotteryDraw(Long userId, Integer num, BigDecimal money, Integer platform, String areaCode) {
        this.build("3029").setUid(userId).setNum(num).setMoney(money).setEventVal(platform).setDtype(platform).setAreaCode(areaCode).save();
    }

    public void initiateWithdrawal(Long userId, BigDecimal money, Integer platform) {
        this.build("3030").setUid(userId).setMoney(money).setDtype(platform).save();
    }

    public void successWithdrawal(Long userId, BigDecimal money) {
        this.build("3031").setUid(userId).setMoney(money).save();
    }

    public void forumSucceed(Long userId, String areaCode, Integer platform) {
        this.build("2011", areaCode).setUid(userId).setDtype(platform).save();
    }

    public void replySucceed(Long userId, Long id, Integer type, String areaCode, Integer platform) {
        this.build("2012", areaCode).setUid(userId).setNid(id).setNType(type).setDtype(platform).save();
    }

    public void shareForumSucceed(Long userId, Long id, String areaCode, Integer platform) {
        this.build("2013", areaCode).setUid(userId).setNid(id).setDtype(platform).save();
    }

    public void forumLikeSucceed(Long userId, Long id, String areaCode, Integer platform) {
        this.build("2010", areaCode).setUid(userId).setNid(id).setDtype(platform).save();
    }

    public void forumCollectSucceed(Long userId, Long id, String areaCode, Integer type, Integer platform) {
        this.build("2014", areaCode).setUid(userId).setNid(id).setDtype(platform).setNType(type).save();
    }

    public void sendRedPacket(Long userId, BigDecimal money, Integer platform) {
        this.build("3032").setUid(userId).setMoney(money).setEventVal(platform).setDtype(platform).save();
    }

    public void receiveRedPacket(Long userId, BigDecimal money, Integer platform) {
        this.build("3033").setUid(userId).setMoney(money).setEventVal(platform).setDtype(platform).save();
    }

    public void report(PointReportParam param) {
        this.bizLogAsyncSaveService.save(param.getMap());
    }
}

