/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.config.SpecialUrlConfig;
import com.bxm.localnews.base.domain.ChannelMapper;
import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.base.service.ChannelService;
import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.ChannelDTO;
import com.bxm.localnews.common.vo.Channel;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ChannelServiceImpl
implements ChannelService {
    private static final Logger logger = LoggerFactory.getLogger(ChannelServiceImpl.class);
    private ChannelMapper channelMapper;
    private RedisStringAdapter redisStringAdapter;
    private BaseUrlFacadeService baseUrlFacadeService;
    private SpecialUrlConfig specialUrlConfig;

    @Override
    public List<ChannelDTO> listChannel(Map<String, Object> searchMap, int current, int pageSize) {
        PageHelper.startPage((int)current, (int)pageSize);
        List list = this.channelMapper.selectChannelList(searchMap);
        String channelUrl = StringUtils.join((Object[])new String[]{this.baseUrlFacadeService.getInnerH5BaseUrl(), this.specialUrlConfig.getChannel()});
        for (ChannelDTO channelDTO : list) {
            channelDTO.setGeneralizeUrl(channelUrl + channelDTO.getCode());
        }
        return list;
    }

    @Override
    public Channel getChannelByCode(String code) {
        Channel channel = new Channel();
        List<Channel> channelList = this.getChannelList();
        for (Channel ch : channelList) {
            if (!ch.getCode().equals(code)) continue;
            channel = ch;
            break;
        }
        return channel;
    }

    private List<Channel> getChannelList() {
        TypeReference<List<Channel>> typeReference = new TypeReference<List<Channel>>(){};
        List channelList = (List)this.redisStringAdapter.get(this.getChannelListKey(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)channelList)) {
            channelList = this.channelMapper.getAllChannel();
            this.redisStringAdapter.set(this.getChannelListKey(), (Object)channelList);
        }
        return channelList;
    }

    private KeyGenerator getChannelListKey() {
        return RedisConfig.BASE_CHANNEL.copy().appendKey((Object)"list");
    }

    @Override
    public void pushChannelInviterInfo(Long userId, String chnl, Long inviterCode) {
        try {
            logger.info("\u4e0a\u4f20\u9080\u8bf7\u5173\u7cfb\uff0c\u6e20\u9053\u7801=" + chnl + ",\u7528\u6237ID=" + userId + ",\u9080\u8bf7\u7801=" + inviterCode);
            if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)chnl) || null == inviterCode) {
                return;
            }
            HashMap<String, Object> searchMap = new HashMap<String, Object>();
            searchMap.put("code", chnl);
            searchMap.put("state", AppConst.STATE_USE);
            Channel channel = this.channelMapper.findSelective(searchMap);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u9080\u8bf7\u5173\u7cfb\u5931\u8d25\uff0c\u6e20\u9053\u7801=" + chnl + ",\u7528\u6237ID=" + userId + ",\u9080\u8bf7\u7801=" + inviterCode);
        }
    }

    public ChannelServiceImpl(ChannelMapper channelMapper, RedisStringAdapter redisStringAdapter, BaseUrlFacadeService baseUrlFacadeService, SpecialUrlConfig specialUrlConfig) {
        this.channelMapper = channelMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.baseUrlFacadeService = baseUrlFacadeService;
        this.specialUrlConfig = specialUrlConfig;
    }
}

