/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.config.DomainConfig;
import com.bxm.localnews.base.service.ClientConfigService;
import com.bxm.localnews.base.service.impl.BaseUrlService;
import com.bxm.localnews.common.config.ClientConfigProperties;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.param.DomainInfoParam;
import com.bxm.localnews.common.param.GetAvailableDomainInfoParam;
import com.bxm.localnews.common.vo.BaseUrlInfo;
import com.bxm.localnews.common.vo.PreloadingH5;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.BasicParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ClientConfigServiceImpl
implements ClientConfigService {
    private static final Logger log = LoggerFactory.getLogger(ClientConfigServiceImpl.class);
    @Autowired
    private ClientConfigProperties clientConfigProperties;
    @Autowired
    private DomainConfig domainConfig;
    @Autowired
    private BaseUrlService baseUrlService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private MessageSender messageSender;

    @Override
    public Integer getJumpUrlType() {
        return this.clientConfigProperties.getJumpUrlType();
    }

    @Override
    public String getValueByKey(String key) {
        return (String)this.clientConfigProperties.getKeys().get(key);
    }

    @Override
    public List<String> listMerchantCategory() {
        return this.clientConfigProperties.getMerchantCategory();
    }

    @Override
    public Map<String, String> getAllConfig(Integer platform) {
        Map commonMap = this.clientConfigProperties.getCommonKeys();
        Map specialMap = platform == 1 ? this.clientConfigProperties.getAndroidKeys() : (platform == 2 ? this.clientConfigProperties.getIosKeys() : (platform == 3 ? this.clientConfigProperties.getWebKeys() : (platform == 5 ? this.clientConfigProperties.getAppletKeys() : this.clientConfigProperties.getKeys())));
        HashMap<String, String> resultMap = new HashMap<String, String>(commonMap);
        resultMap.putAll(specialMap);
        this.replaceBaseUrl(resultMap);
        return resultMap;
    }

    private void replaceBaseUrl(Map<String, String> resultMap) {
        List preloadingH5s;
        String preloadingH5;
        DomainInfoParam param = new DomainInfoParam();
        param.setScene(Objects.toString(DomainScene.INNER_H5));
        String baseH5UrlBySceneF = this.getBaseH5UrlByScene(param);
        if (StringUtils.isBlank((CharSequence)baseH5UrlBySceneF)) {
            log.warn("\u6ca1\u6709\u53ef\u7528\u7684\u7ad9\u5185H5\u57df\u540d\uff0c\u9009\u7528\u9ed8\u8ba4\u914d\u7f6e\u7684\uff0c\u8bf7\u53ca\u65f6\u914d\u7f6e");
            baseH5UrlBySceneF = this.domainConfig.getDefaultInnerH5BaseUrl();
        }
        String baseH5UrlByScene = baseH5UrlBySceneF;
        if (StringUtils.isNotBlank((CharSequence)resultMap.get("h5Server")) && StringUtils.isNotBlank((CharSequence)baseH5UrlByScene)) {
            resultMap.put("h5Server", baseH5UrlByScene);
        }
        if (StringUtils.isNotBlank((CharSequence)(preloadingH5 = resultMap.get("preloadingH5"))) && !CollectionUtils.isEmpty((Collection)(preloadingH5s = JSON.parseArray((String)preloadingH5, PreloadingH5.class))) && StringUtils.isNotBlank((CharSequence)baseH5UrlByScene)) {
            preloadingH5s.forEach(p -> {
                if (StringUtils.isNotBlank((CharSequence)p.getPath())) {
                    p.setUrl(StringUtils.join((Object[])new String[]{baseH5UrlByScene, p.getPath()}));
                    p.setPath(null);
                }
            });
            resultMap.put("preloadingH5", JSON.toJSONString((Object)preloadingH5s));
        }
    }

    @Override
    public String getBaseH5UrlByScene(DomainInfoParam param) {
        BaseUrlInfo baseUrlInfo;
        GetAvailableDomainInfoParam infoParam = new GetAvailableDomainInfoParam();
        infoParam.merge((BasicParam)param);
        infoParam.setScene(param.getScene());
        infoParam.setViewScene(param.getViewScene());
        if (StringUtils.isBlank((CharSequence)infoParam.getScene())) {
            infoParam.setScene(Objects.toString(DomainScene.OUTSIDE_SHARE));
            infoParam.setViewScene(Objects.toString(DomainScene.DomainViewScene.CONTENT_VIEW));
        }
        if (Objects.isNull(baseUrlInfo = this.baseUrlService.getBaseUrlInfo(infoParam)) || StringUtils.isBlank((CharSequence)baseUrlInfo.getBaseUrl())) {
            String msg = String.format("\u3010\u7d27\u6025\u3011\u83b7\u53d6h5\u7684base url\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\u8bf7\u53ca\u65f6\u5173\u6ce8\uff0c\u8d3c\u91cd\u8981\uff01\uff01\uff01\uff01\uff01\u4e8b\u4ef6id: %s ", this.sequenceCreater.nextStringId());
            this.messageSender.sendDingtalk(DingtalkMessage.builder().content(msg).build());
            log.warn(msg + "param: {}", (Object)JSON.toJSONString((Object)param));
            return "https://web.wstong.com/h5/";
        }
        return baseUrlInfo.getBaseUrl();
    }
}

