/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.DictMapper;
import com.bxm.localnews.base.service.DictService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.DictDto;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
implements DictService {
    private static final Logger log = LoggerFactory.getLogger(DictServiceImpl.class);
    private RedisHashMapAdapter redisHashMapAdapter;
    private final DictMapper dictMapper;
    private TypeReference<List<DictDto>> typeReference = new TypeReference<List<DictDto>>(){};

    @Autowired
    public DictServiceImpl(RedisHashMapAdapter redisHashMapAdapter, DictMapper dictMapper) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.dictMapper = dictMapper;
    }

    @Override
    public List<DictDto> load(String group, Integer deep) {
        Preconditions.checkArgument((null != group ? 1 : 0) != 0);
        List result = (List)this.redisHashMapAdapter.get(RedisConfig.DICT_CACHE, group, this.typeReference);
        if (null == result) {
            result = this.dictMapper.query(group);
            this.redisHashMapAdapter.put(RedisConfig.DICT_CACHE, group, (Object)result);
        }
        List<DictDto> finalResult = result.stream().filter(item -> null == item.getParentId()).collect(Collectors.toList());
        if (deep == null || deep == 0) {
            deep = Integer.MAX_VALUE;
        }
        for (DictDto dict : finalResult) {
            this.lookup(dict, result, deep - 1);
        }
        return finalResult;
    }

    private void lookup(DictDto parent, List<DictDto> data, int deep) {
        if (deep == 0) {
            return;
        }
        data.forEach(item -> {
            if (StringUtils.equals((String)String.valueOf(item.getParentId()), (String)parent.getCode())) {
                parent.addChild(item);
                this.lookup((DictDto)item, data, deep - 1);
            }
        });
    }

    @Override
    public List<DictDto> children(String parentCode) {
        if (StringUtils.isBlank((String)parentCode)) {
            log.info("\u83b7\u53d6\u4e0b\u7ea7\u6570\u636e\u5b57\u5178\u65f6\uff0c\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u6570\u7ec4");
            return Lists.newArrayList();
        }
        List result = (List)this.redisHashMapAdapter.get(RedisConfig.DICT_CACHE, parentCode, this.typeReference);
        if (result == null) {
            result = this.dictMapper.queryByParent(parentCode);
            this.redisHashMapAdapter.put(RedisConfig.DICT_CACHE, parentCode, (Object)result);
        }
        return result;
    }
}

