/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.base.domain.CommonEquipmentAppMapper;
import com.bxm.localnews.base.domain.EquipmentExtraInfoMapper;
import com.bxm.localnews.base.domain.EquipmentInfoMapper;
import com.bxm.localnews.base.service.EquipmentService;
import com.bxm.localnews.common.constant.EquipmentEnum;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.EquipmentDTO;
import com.bxm.localnews.common.param.AppInfoParam;
import com.bxm.localnews.common.param.EquipmentParam;
import com.bxm.localnews.common.vo.CommonEquipmentApp;
import com.bxm.localnews.common.vo.EquipmentExtraInfo;
import com.bxm.localnews.common.vo.EquipmentInfo;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class EquipmentServiceImpl
extends BaseService
implements EquipmentService {
    private static final String[] BLANK_IDFA = new String[]{"0000000000000000", "00000000-0000-0000-0000-000000000000"};
    private final EquipmentInfoMapper equipmentInfoMapper;
    private final EquipmentExtraInfoMapper equipmentExtraInfoMapper;
    private final RedisStringAdapter redisStringAdapter;
    private final DistributedLock distributedLock;
    private final CommonEquipmentAppMapper commonEquipmentAppMapper;

    @Autowired
    public EquipmentServiceImpl(EquipmentInfoMapper equipmentInfoMapper, EquipmentExtraInfoMapper equipmentExtraInfoMapper, RedisStringAdapter redisStringAdapter, DistributedLock distributedLock, CommonEquipmentAppMapper commonEquipmentAppMapper) {
        this.equipmentInfoMapper = equipmentInfoMapper;
        this.equipmentExtraInfoMapper = equipmentExtraInfoMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.distributedLock = distributedLock;
        this.commonEquipmentAppMapper = commonEquipmentAppMapper;
    }

    @Override
    @Retryable(backoff=@Backoff(value=200L), value={RetryException.class})
    public String save(EquipmentParam param) {
        EquipmentDTO equipment;
        String requestId = this.nextSequence().toString();
        String key = String.valueOf(param.hashCode());
        if (!this.distributedLock.lock(key, requestId)) {
            this.logger.error("\u5b58\u5728\u91cd\u590d\u8bf7\u6c42\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
            throw new RetryException("\u91cd\u590d\u8bf7\u6c42");
        }
        String devcId = param.getDevcId();
        if (NumberUtils.isDigits((String)devcId) && null != (equipment = this.get(devcId))) {
            this.execSave(param, equipment);
            this.distributedLock.unlock(key, requestId);
            return devcId;
        }
        String equipmentId = this.existsEquipment(param);
        if (equipmentId != null) {
            devcId = equipmentId;
            param.setDevcId(devcId);
            this.execSave(param, this.get(devcId));
            this.distributedLock.unlock(key, requestId);
            return devcId;
        }
        if (StringUtils.isBlank((CharSequence)devcId) || !NumberUtils.isDigits((String)devcId)) {
            devcId = String.valueOf(this.nextId());
            param.setDevcId(devcId);
        }
        this.execSave(param, null);
        this.distributedLock.unlock(key, requestId);
        return devcId;
    }

    private String existsEquipment(EquipmentParam param) {
        ArrayList identifiers = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)param.getDevcId())) {
            this.add(identifiers, param.getDevcId());
        }
        this.add(identifiers, param.getAndroidId());
        this.add(identifiers, param.getAndroidUuid());
        this.add(identifiers, param.getIMEI());
        this.add(identifiers, param.getIdfa());
        this.add(identifiers, param.getIosId());
        return this.equipmentInfoMapper.selectByIdentifiers((List)identifiers);
    }

    private void add(List<String> identifiers, String unique) {
        if (this.verify(unique)) {
            identifiers.add(unique);
        }
    }

    private boolean verify(String unique) {
        if (StringUtils.isNotBlank((CharSequence)unique)) {
            return !StringUtils.equalsAny((CharSequence)unique, (CharSequence[])BLANK_IDFA);
        }
        return false;
    }

    private void execSave(EquipmentParam param, EquipmentDTO exists) {
        EquipmentDTO request = new EquipmentDTO();
        org.springframework.beans.BeanUtils.copyProperties((Object)param, (Object)request);
        request.setId(param.getDevcId());
        if (request.equals((Object)exists)) {
            return;
        }
        ((EquipmentServiceImpl)SpringContextHolder.getBean(this.getClass())).saveWithAsync(request, exists, param);
    }

    @Override
    @Async
    public void saveWithAsync(EquipmentDTO requestEquipment, EquipmentDTO existsEquipment, EquipmentParam equipmentParam) {
        EquipmentExtraInfo extraInfo;
        ArrayList<CommonEquipmentApp> commonEquipmentAppList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)equipmentParam.getAppInfoParamList())) {
            List appInfoParamList = JSONObject.parseArray((String)equipmentParam.getAppInfoParamList(), AppInfoParam.class);
            commonEquipmentAppList = appInfoParamList.stream().map(e -> {
                CommonEquipmentApp commonEquipmentApp = new CommonEquipmentApp();
                commonEquipmentApp.setAppName(e.getAppName());
                commonEquipmentApp.setPackageName(e.getPackageName());
                commonEquipmentApp.setId(Long.valueOf(equipmentParam.getDevcId()));
                commonEquipmentApp.setModifyTime(new Date());
                commonEquipmentApp.setCreateTime(new Date());
                return commonEquipmentApp;
            }).collect(Collectors.toList());
        }
        if (null == existsEquipment) {
            extraInfo = this.extract(requestEquipment);
            if (StringUtils.isBlank((CharSequence)requestEquipment.getId())) {
                extraInfo.setId(String.valueOf(this.nextId()));
            }
            extraInfo.setCreateTime(new Date());
            this.equipmentExtraInfoMapper.insert(extraInfo);
            this.addAppInfo(commonEquipmentAppList);
            requestEquipment.setId(extraInfo.getId());
            this.saveUniqueInfo(requestEquipment);
        } else {
            if (!requestEquipment.baseInfoEquals(existsEquipment)) {
                extraInfo = this.extract(requestEquipment);
                extraInfo.setId(existsEquipment.getId());
                extraInfo.setModifyTime(new Date());
                this.equipmentExtraInfoMapper.updateByPrimaryKeySelective(extraInfo);
            }
            if (!requestEquipment.uniqueEquals(existsEquipment)) {
                this.equipmentInfoMapper.deleteById(existsEquipment.getId());
                requestEquipment.setId(existsEquipment.getId());
                this.saveUniqueInfo(requestEquipment);
            }
            if (this.isNotEquals(existsEquipment.getApps(), commonEquipmentAppList)) {
                if (!StringUtils.isNumeric((CharSequence)equipmentParam.getDevcId())) {
                    this.logger.warn("\u8bbe\u5907\u53f7: {} \u4e0d\u6b63\u5e38\uff0c\u65e0\u6cd5\u6e05\u9664\u8bbe\u5907\u4fe1\u606f", (Object)equipmentParam.getDevcId());
                } else {
                    this.commonEquipmentAppMapper.delete(Long.valueOf(equipmentParam.getDevcId()));
                    MybatisBatchBuilder.create(CommonEquipmentAppMapper.class, commonEquipmentAppList).run(CommonEquipmentAppMapper::insert);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u8bbe\u5907\u5b89\u88c5\u4fe1\u606f\u5217\u8868\u53d8\u66f4\uff1a{}", (Object)requestEquipment);
                }
            }
        }
        this.redisStringAdapter.remove(this.build(requestEquipment.getId()));
    }

    private void addAppInfo(List<CommonEquipmentApp> commonEquipmentAppList) {
        MybatisBatchBuilder.create(CommonEquipmentAppMapper.class, commonEquipmentAppList).run(CommonEquipmentAppMapper::insert);
    }

    private boolean isNotEquals(List source, List target) {
        if (null == source && null == target) {
            return false;
        }
        if (null == source || null == target) {
            return true;
        }
        return !CollectionUtils.isEqualCollection((Collection)source, (Collection)target);
    }

    private void saveUniqueInfo(EquipmentDTO equipment) {
        ArrayList uniqueList = Lists.newArrayList();
        this.addEquipmentInfo(uniqueList, equipment.getAndroidId(), EquipmentEnum.ANDROID_ID, equipment.getId());
        this.addEquipmentInfo(uniqueList, equipment.getAndroidUuid(), EquipmentEnum.ANDROID_UUID, equipment.getId());
        this.addEquipmentInfo(uniqueList, equipment.getIMEI(), EquipmentEnum.ANDROID_IMEI, equipment.getId());
        this.addEquipmentInfo(uniqueList, equipment.getIdfa(), EquipmentEnum.IOS_IDFA, equipment.getId());
        this.addEquipmentInfo(uniqueList, equipment.getIosId(), EquipmentEnum.IOS_DEVICE_ID, equipment.getId());
        this.equipmentInfoMapper.insert((List)uniqueList);
    }

    private void addEquipmentInfo(List<EquipmentInfo> uniqueList, String unique, EquipmentEnum equipmentType, String equipmentId) {
        if (this.verify(unique)) {
            EquipmentInfo info = EquipmentInfo.builder().id(equipmentId).identifierName(equipmentType.name()).identifierValue(unique).createTime(new Date()).build();
            uniqueList.add(info);
        }
    }

    private EquipmentExtraInfo extract(EquipmentDTO equipment) {
        EquipmentExtraInfo extraInfo = new EquipmentExtraInfo();
        org.springframework.beans.BeanUtils.copyProperties((Object)equipment, (Object)extraInfo);
        extraInfo.setCurrentVersion(equipment.getCurVer());
        return extraInfo;
    }

    @Override
    public EquipmentDTO getByDeviceId(String deviceId) {
        EquipmentDTO equipmentDTO = this.get(deviceId);
        if (Objects.nonNull(equipmentDTO)) {
            return equipmentDTO;
        }
        String equipmentId = this.equipmentInfoMapper.selectByIdentifiers((List)ImmutableList.of((Object)deviceId));
        if (null != equipmentId) {
            return this.get(equipmentId);
        }
        return null;
    }

    private KeyGenerator build(String id) {
        return RedisConfig.EQUIPMENT_CACHE.copy().appendKey((Object)id);
    }

    @Override
    public EquipmentDTO get(String id) {
        KeyGenerator key = this.build(id);
        EquipmentDTO equipment = (EquipmentDTO)this.redisStringAdapter.get(key, EquipmentDTO.class);
        if (equipment == null) {
            EquipmentExtraInfo equipmentExtraInfo = this.equipmentExtraInfoMapper.selectByPrimaryKey(id);
            if (null == equipmentExtraInfo) {
                return null;
            }
            equipment = new EquipmentDTO();
            equipment.setId(equipmentExtraInfo.getId());
            equipment.setEnableNotification(equipmentExtraInfo.getEnableNotification());
            equipment.setCurVer(equipmentExtraInfo.getCurrentVersion());
            equipment.setOperatingSystem(equipmentExtraInfo.getOperatingSystem());
            equipment.setPhoneModel(equipmentExtraInfo.getPhoneModel());
            equipment.setPlatform(equipmentExtraInfo.getPlatform());
            List equipmentInfos = this.equipmentInfoMapper.selectByPrimaryKey(id);
            if (CollectionUtils.isNotEmpty((Collection)equipmentInfos)) {
                HashMap map = new HashMap(3);
                equipmentInfos.forEach(equipmentInfo -> map.put(EquipmentEnum.valueOf((String)equipmentInfo.getIdentifierName()).getType(), equipmentInfo.getIdentifierValue()));
                try {
                    BeanUtils.populate((Object)equipment, map);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (StringUtils.isNumeric((CharSequence)id)) {
                equipment.setApps(this.commonEquipmentAppMapper.getEquipmentApps(Long.valueOf(id)));
            }
            this.redisStringAdapter.set(key, (Object)equipment);
        }
        return equipment;
    }
}

