/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.manage;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.base.domain.BaseDomainExtendMapper;
import com.bxm.localnews.base.domain.BaseDomainPublishExtendMapper;
import com.bxm.localnews.base.domain.WechatMpInfoExtendMapper;
import com.bxm.localnews.base.service.domain.mointer.MoniterService;
import com.bxm.localnews.base.service.manage.DomainManageService;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.entity.BaseDomainPublish;
import com.bxm.localnews.common.entity.DomainPublishInfo;
import com.bxm.localnews.common.entity.TBaseDomain;
import com.bxm.localnews.common.entity.WechatMpInfo;
import com.bxm.localnews.common.param.AddBaseDomainParam;
import com.bxm.localnews.common.param.AddDomainPublishParam;
import com.bxm.localnews.common.param.DomainListParam;
import com.bxm.localnews.common.param.DomainPublishListParam;
import com.bxm.localnews.common.param.EditBaseDomainParam;
import com.bxm.localnews.common.param.EditDomainPublishParam;
import com.bxm.localnews.common.vo.DomainInfoVO;
import com.bxm.localnews.common.vo.DomainVO;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DomainManageServiceImpl
implements DomainManageService {
    private static final Logger log = LoggerFactory.getLogger(DomainManageServiceImpl.class);
    private final BaseDomainPublishExtendMapper baseDomainPublishExtendMapper;
    private final BaseDomainExtendMapper baseDomainExtendMapper;
    private final SequenceCreater sequenceCreater;
    private final MoniterService moniterService;
    private final MessageSender messageSender;
    private final WechatMpInfoExtendMapper wechatMpInfoExtendMapper;

    @Override
    public List<DomainVO> listAll(DomainListParam param) {
        param.setStatus(Byte.valueOf((byte)1));
        return this.baseDomainExtendMapper.selectAllAvailable().stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public PageWarper<DomainVO> list(DomainListParam param) {
        Page domains = PageMethod.startPage((Object)param).doSelectPage(() -> this.baseDomainExtendMapper.selectByParam(param));
        PageWarper pageWarper = new PageWarper((List)domains);
        pageWarper.setList(domains.stream().map(this::convert).collect(Collectors.toList()));
        return pageWarper;
    }

    private DomainVO convert(TBaseDomain domain) {
        DomainVO vo = new DomainVO();
        BeanUtils.copyProperties((Object)domain, (Object)vo);
        vo.setStatusStr(this.statusStr(vo.getStatus()));
        return vo;
    }

    private String statusStr(byte status) {
        switch (status) {
            case 1: {
                return "\u4e0a\u67b6";
            }
            case 2: {
                return "\u5fae\u4fe1\u88ab\u5c01";
            }
            case 3: {
                return "\u57df\u540d\u5907\u4efd\u4e22\u5931";
            }
        }
        return "\u4e0b\u67b6";
    }

    @Override
    public Message add(AddBaseDomainParam param) {
        Date now = new Date();
        Arrays.stream(param.getDomain().split("\n")).forEach(p -> {
            List tBaseDomains = this.baseDomainExtendMapper.selectByDomain(p);
            if (!CollectionUtils.isEmpty((Collection)tBaseDomains)) {
                return;
            }
            TBaseDomain domain = new TBaseDomain();
            domain.setId(this.sequenceCreater.nextLongId());
            domain.setDomain(p);
            domain.setStatus(param.getStatus());
            domain.setCreateTime(now);
            domain.setModifyTime(now);
            this.baseDomainExtendMapper.insertSelective(domain);
        });
        return Message.build();
    }

    @Override
    public Message edit(EditBaseDomainParam param) {
        TBaseDomain update = new TBaseDomain();
        BeanUtils.copyProperties((Object)param, (Object)update);
        update.setModifyTime(new Date());
        this.baseDomainExtendMapper.updateByPrimaryKeySelective(update);
        return Message.build();
    }

    @Override
    public Message deleteOneDomain(Long id) {
        this.baseDomainExtendMapper.deleteOne(id);
        return Message.build();
    }

    @Override
    public PageWarper<DomainInfoVO> publishList(DomainPublishListParam param) {
        Page page = PageMethod.startPage((Object)param).doSelectPage(() -> this.baseDomainPublishExtendMapper.selectByParam(param));
        PageWarper pageWarper = new PageWarper((List)page);
        pageWarper.setList(page.stream().map(this::build).collect(Collectors.toList()));
        return pageWarper;
    }

    private DomainInfoVO build(DomainPublishInfo info) {
        WechatMpInfo wechatMpInfo;
        DomainInfoVO vo = new DomainInfoVO();
        BeanUtils.copyProperties((Object)info, (Object)vo);
        vo.setBaseUrl(StringUtils.join((Object[])new String[]{info.getProtocol(), info.getDomain()}));
        if (Objects.nonNull(info.getScene())) {
            Optional domainScene = DomainScene.forScene((byte)info.getScene());
            vo.setSceneStr(domainScene.isPresent() ? ((DomainScene)domainScene.get()).getDesc() : "");
        }
        if (Objects.nonNull(info.getViewScene())) {
            Optional domainViewScene = DomainScene.DomainViewScene.forViewScene((byte)info.getViewScene());
            vo.setViewSceneStr(domainViewScene.isPresent() ? ((DomainScene.DomainViewScene)domainViewScene.get()).getDesc() : "");
        }
        vo.setStatusStr(Objects.equals(vo.getStatus(), (byte)1) ? "\u53ef\u7528" : "\u4e0d\u53ef\u7528");
        vo.setWechatMpName("\u6682\u65e0");
        if (StringUtils.isNotBlank((CharSequence)info.getAppId()) && Objects.nonNull(wechatMpInfo = this.wechatMpInfoExtendMapper.loadByAppId(info.getAppId()))) {
            vo.setWechatMpName(wechatMpInfo.getName());
        }
        return vo;
    }

    @Override
    public Message publishAdd(AddDomainPublishParam param) {
        if (Objects.equals(param.getScene(), DomainScene.OUTSIDE_SHARE_VIEW.getScene()) && Objects.isNull(param.getViewScene())) {
            return Message.build((boolean)false, (String)"\u5982\u679c\u6295\u653e\u4e3a\u843d\u5730\u9875\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u843d\u5730\u9875\u573a\u666f");
        }
        TBaseDomain domain = this.baseDomainExtendMapper.selectByPrimaryKey(param.getDomainId());
        if (Objects.isNull(domain)) {
            return Message.build((boolean)false, (String)"\u8981\u7ed1\u5b9a\u7684\u57df\u540d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528");
        }
        Optional domainScene = DomainScene.forScene((byte)param.getScene());
        if (!domainScene.isPresent()) {
            return Message.build((boolean)false, (String)StringUtils.join((Object[])new Serializable[]{"\u573a\u666f", param.getScene(), "\u4e0d\u5b58\u5728"}));
        }
        Date now = new Date();
        BaseDomainPublish publish = new BaseDomainPublish();
        publish.setId(this.sequenceCreater.nextLongId());
        publish.setDomainId(param.getDomainId());
        publish.setProtocol(param.getProtocol());
        publish.setScene(param.getScene());
        publish.setViewScene(param.getViewScene());
        publish.setAppId(param.getAppId());
        publish.setRemark(param.getRemark());
        publish.setStatus(param.getStatus());
        publish.setCreateTime(now);
        publish.setModifyTime(now);
        this.baseDomainPublishExtendMapper.insertSelective(publish);
        return Message.build();
    }

    @Override
    public Message publishEdit(EditDomainPublishParam param) {
        String protocol;
        BaseDomainPublish publish = this.baseDomainPublishExtendMapper.selectByPrimaryKey(param.getId());
        if (Objects.isNull(publish)) {
            return Message.build((boolean)false, (String)"\u6295\u653e\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(param.getScene(), DomainScene.OUTSIDE_SHARE_VIEW.getScene()) && Objects.isNull(param.getViewScene())) {
            return Message.build((boolean)false, (String)"\u5982\u679c\u6295\u653e\u4e3a\u843d\u5730\u9875\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u843d\u5730\u9875\u573a\u666f");
        }
        String string = protocol = StringUtils.isNotBlank((CharSequence)param.getProtocol()) ? param.getProtocol() : publish.getProtocol();
        if (StringUtils.isBlank((CharSequence)protocol)) {
            return Message.build((boolean)false, (String)"\u534f\u8bae\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TBaseDomain domain = this.baseDomainExtendMapper.selectByPrimaryKey(Objects.nonNull(param.getDomainId()) ? param.getDomainId() : publish.getDomainId());
        if (Objects.isNull(domain)) {
            return Message.build((boolean)false, (String)"\u8981\u7ed1\u5b9a\u7684\u57df\u540d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528");
        }
        byte scene = Objects.isNull(param.getScene()) ? publish.getScene() : param.getScene();
        Optional domainScene = DomainScene.forScene((byte)scene);
        if (!domainScene.isPresent()) {
            return Message.build((boolean)false, (String)StringUtils.join((Object[])new Serializable[]{"\u573a\u666f", Byte.valueOf(scene), "\u4e0d\u5b58\u5728"}));
        }
        BaseDomainPublish update = new BaseDomainPublish();
        BeanUtils.copyProperties((Object)param, (Object)update);
        update.setModifyTime(new Date());
        this.baseDomainPublishExtendMapper.updateByPrimaryKeySelective(update);
        return Message.build();
    }

    @Override
    public Message deleteOneDomainPublish(Long id) {
        this.baseDomainPublishExtendMapper.deleteOne(id);
        return Message.build();
    }

    @Override
    public void scheduleCheckDomain() {
        Date now = new Date();
        List infos = this.baseDomainPublishExtendMapper.selectAllAvailableDomain();
        infos.forEach(p -> {
            Optional domainScene = DomainScene.forScene((byte)p.getScene());
            if (!domainScene.isPresent()) {
                log.warn("\u573a\u666f: {} \u4e0d\u5b58\u5728", (Object)p.getScene());
                return;
            }
            log.info("\u6821\u9a8c\u57df\u540d: info {}", (Object)JSON.toJSONString((Object)p));
            if (!this.moniterService.checkBaseUrlAvailable(StringUtils.join((Object[])new String[]{p.getProtocol(), p.getDomain()}), (DomainScene)domainScene.get())) {
                log.info("\u57df\u540d: {} \u7c7b\u578b: {} \u6821\u9a8c\u4e0d\u6210\u529f\uff0c\u4e0b\u67b6\u57df\u540d", (Object)p.getDomain(), domainScene.get());
                this.messageSender.sendDingtalk(DingtalkMessage.builder().content(StringUtils.join((Object[])new Serializable[]{"\u57df\u540d", p.getDomain(), "\u7c7b\u578b", (Serializable)domainScene.get(), "\u68c0\u6d4b\u4e0d\u6210\u529f\uff0c\u5c06\u8fdb\u884c\u4e0b\u67b6\u64cd\u4f5c\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u5bf9\u5e94\u7c7b\u578b\u7684\u57df\u540d\uff01\uff01\uff01\uff01"})).build());
            }
        });
    }

    public DomainManageServiceImpl(BaseDomainPublishExtendMapper baseDomainPublishExtendMapper, BaseDomainExtendMapper baseDomainExtendMapper, SequenceCreater sequenceCreater, MoniterService moniterService, MessageSender messageSender, WechatMpInfoExtendMapper wechatMpInfoExtendMapper) {
        this.baseDomainPublishExtendMapper = baseDomainPublishExtendMapper;
        this.baseDomainExtendMapper = baseDomainExtendMapper;
        this.sequenceCreater = sequenceCreater;
        this.moniterService = moniterService;
        this.messageSender = messageSender;
        this.wechatMpInfoExtendMapper = wechatMpInfoExtendMapper;
    }
}

