/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.vo;

import com.bxm.localnews.base.service.BizLogAsyncSaveService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Map;

public class BizLogParamBuilder {
    private Map<String, String> result = Maps.newHashMap();
    private BizLogAsyncSaveService bizLogAsyncSaveService;

    private BizLogParamBuilder() {
    }

    public static BizLogParamBuilder build(String event, BizLogAsyncSaveService bizLogAsyncSaveService) {
        BizLogParamBuilder builder = new BizLogParamBuilder();
        builder.get().put("e", event);
        builder.get().put("p", "news");
        builder.get().put("dtype", "3");
        builder.get().put("ts", System.currentTimeMillis() + "");
        builder.setBizLogAsyncSaveService(bizLogAsyncSaveService);
        return builder;
    }

    public static BizLogParamBuilder build(String event, String areaCode, BizLogAsyncSaveService bizLogAsyncSaveService) {
        return BizLogParamBuilder.build(event, bizLogAsyncSaveService).setAreaCode(areaCode);
    }

    public BizLogParamBuilder setUid(Long userId) {
        this.result.put("uid", this.convert(userId));
        return this;
    }

    public BizLogParamBuilder setActivityId(Long privilegeId) {
        this.result.put("activityid", this.convert(privilegeId));
        return this;
    }

    public BizLogParamBuilder setEventVal(Object val) {
        this.result.put("ev", this.convert(val));
        return this;
    }

    public BizLogParamBuilder setSrc(Long channel) {
        this.result.put("src", this.convert(channel));
        return this;
    }

    public BizLogParamBuilder setPageSource(String source) {
        this.result.put("page_src", this.convert(source));
        return this;
    }

    public BizLogParamBuilder setIsOnline(Integer isOnline) {
        this.result.put("is_online", this.convert(isOnline));
        return this;
    }

    public BizLogParamBuilder setIp(String ip) {
        this.result.put("ip", this.convert(ip));
        return this;
    }

    public BizLogParamBuilder setToken(String token) {
        this.result.put("token", this.convert(token));
        return this;
    }

    public BizLogParamBuilder setPageSrc(String pageSrc) {
        this.result.put("page_src", this.convert(pageSrc));
        return this;
    }

    public BizLogParamBuilder setOneline(int oneline) {
        this.result.put("is_online", this.convert(oneline));
        return this;
    }

    public BizLogParamBuilder setMid(String mid) {
        this.result.put("mid", this.convert(mid));
        return this;
    }

    public BizLogParamBuilder setAreaCode(String areaCode) {
        this.result.put("a", this.convert(areaCode));
        return this;
    }

    public BizLogParamBuilder setNum(Integer num) {
        this.result.put("num", num.toString());
        return this;
    }

    public BizLogParamBuilder setMoney(BigDecimal money) {
        this.result.put("money", money.toString());
        return this;
    }

    public BizLogParamBuilder setNid(Long nid) {
        this.result.put("nid", this.convert(nid));
        return this;
    }

    public BizLogParamBuilder setNType(Integer type) {
        this.result.put("n_type", this.convert(type));
        return this;
    }

    public BizLogParamBuilder setRid(String rid) {
        this.result.put("rid", this.convert(rid));
        return this;
    }

    public BizLogParamBuilder setDtype(Integer dtype) {
        if (null != dtype) {
            this.result.put("dtype", dtype.toString());
        }
        return this;
    }

    private void setBizLogAsyncSaveService(BizLogAsyncSaveService bizLogAsyncSaveService) {
        this.bizLogAsyncSaveService = bizLogAsyncSaveService;
    }

    private String convert(Object obj) {
        if (null == obj) {
            return "";
        }
        return obj.toString();
    }

    private Map<String, String> get() {
        return this.result;
    }

    public void save() {
        this.bizLogAsyncSaveService.save(this.result);
    }
}

