package com.bxm.localnews.base.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author zhaoyadong 2018/10/18 15:39
 * @desc
 */
@Data
@Component
@ConfigurationProperties("base.config.domain")
public class DomainConfig {

    /**
     * 缓存开关
     * true 开启缓存
     */
    private Boolean cacheSwitch = Boolean.TRUE;

    /**
     * 域名监控开关 默认关闭 需要确保当前域名是否都是可以获取成功的，不然就会进行下架导致线上事故了！！！！！
     */
    private Boolean mointerSwitch = Boolean.FALSE;

    /**
     * 默认的站内H5base url
     */
    private String defaultInnerH5BaseUrl;

    /**
     * 极端情况下，没有获取到url的时候返回的
     * key: scene
     * value: base url
     */
    private Map<String, String>  defaultBaseUrl = Maps.newHashMap();

    /**
     * 需要剔除查询出来的落地页场景的域名
     */
    private List<String> exclusionViewSceneDomains = Lists.newArrayList("web.52huola.cn");

}
