package com.bxm.localnews.base.service;

import com.bxm.localnews.common.dto.DictDto;

import java.util.List;

/**
 * 数据字典服务
 * @author liujia
 */
public interface DictService {

    /**
     * 加载数据字典
     * @param group 数据字典分组，详见CF定义
     * @param deep  拉取深度
     * @return 数据字典列表
     */
    List<DictDto> load(String group, Integer deep);

    /**
     * 获取数据字典的下级列表
     * @param parentCode 上级
     * @return
     */
    List<DictDto> children(String parentCode);
}
