package com.bxm.localnews.base.service.domain.joins;

import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.dto.JointerContext;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 站外落地页域名拼接
 * eg: https://domain/h5/
 * @author gonzo
 * @date 2020-07-31 21:02
 **/
@Component
public class OutsideShareViewSceneBaseUrlJointer implements SceneBaseUrlJointer {

    @Override
    public String join(JointerContext context) {
        return StringUtils.join(context.getUrl(), SEG, BASE_H5_URL);
    }

    @Override
    public DomainScene support() {
        return DomainScene.OUTSIDE_SHARE_VIEW;
    }
}
