package com.bxm.localnews.base.service.domain.joins;

import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.dto.JointerContext;

/**
 * 场景的base url拼接器接口定义
 * @author gonzo
 * @date 2020-07-30 19:03
 **/
public interface SceneBaseUrlJointer {

    String SEG = "/";

    String BASE_H5_URL = "h5/";

    /**
     * 根据当前支持的场景 拼接base url
     * @param context 拼接上下文
     * @return 拼接后的base url
     */
    String join(JointerContext context);

    /**
     * 当前拼接处理器支持的类型
     * @return 支持的类型
     */
    DomainScene support();
}
