package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.AreaDivisionMapper;
import com.bxm.localnews.base.service.AreaService;
import com.bxm.localnews.common.vo.AreaDivision;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.bxm.localnews.common.constant.RedisConfig.AREA_INFO_MAP;

@Service
public class AreaServiceImpl implements AreaService {

    private AreaDivisionMapper areaDivisionMapper;

    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public AreaServiceImpl(AreaDivisionMapper areaDivisionMapper, RedisHashMapAdapter redisHashMapAdapter) {
        this.areaDivisionMapper = areaDivisionMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public AreaDivision getCacheArea(String code) {
        AreaDivision area = redisHashMapAdapter.get(AREA_INFO_MAP, code, AreaDivision.class);
        if (area == null) {
            area = areaDivisionMapper.selectByCode(code);
            if (area != null) {
                redisHashMapAdapter.put(AREA_INFO_MAP, code, area);
            } else {
                area = new AreaDivision();
            }
        }
        return area;
    }

    @Override
    public String getBizLogArea(String code) {
        if (null != code && code.length() >= 6) {
            String result = getCacheArea(code.substring(0, 2)).getName() + "," +
                    getCacheArea(code.substring(0, 4) + "00000000").getName();

            String lastLevel = code.substring(4, 6);
            if (!"00".equals(lastLevel)) {
                result += "," + getCacheArea(code.substring(0, 6) + "000000").getName();
            }
            return result;
        }
        return null;
    }

}
