package com.bxm.localnews.base.service.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;

import com.bxm.localnews.base.config.LocationProperties;
import com.bxm.localnews.base.domain.LocationRelationMapper;
import com.bxm.localnews.base.service.LocationRelationService;
import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.dto.LocationRelationDTO;
import com.bxm.localnews.common.vo.LocationRelation;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationRelationServiceImpl extends BaseService implements LocationRelationService {

    @Autowired
    LocationRelationMapper locationRelationMapper;

    @Autowired
    RedisStringAdapter redisStringAdapter;

    @Autowired
    private LocationProperties locationProperties;

    @Override
    public LocationRelationDTO getLocationRelation(String code, Byte type) {
        //固定获取某个区域的分享语(2019-5-8取消ABtest)
//        Long increValue = redisStringAdapter.increment(getFixedShareCode());
//        if (increValue % 2 == 0 && !"330127000000".equals(code)) {
//            code = "330127000000";
//        }
        LocationRelation relation = new LocationRelation();
        relation.setLocationCode(code);
        relation.setType(generateType(type));
        List<LocationRelation> locationRelationList = locationRelationMapper.selectByModel(relation);
        if (CollectionUtils.isNotEmpty(locationRelationList)) {
            //在shareTime不一致的情况下仍能保持平均分配
            LocationRelation locationRelation = locationRelationList.get(0);
            Integer sign = locationRelation.getShareTime() % 2;
            for (LocationRelation lr : locationRelationList) {
                if (lr.getShareTime() % 2 != sign) {
                    locationRelation = lr;
                    break;
                }
            }

            locationRelation.setShareTime(locationRelation.getShareTime() + 1);
            locationRelationMapper.updateByPrimaryKey(locationRelation);
            return convertLocationRelation(locationRelation);
        }
        return new LocationRelationDTO();
    }

    /**
     * 随机生成对应的分享类型信息
     *
     * @param type
     * @return
     */
    private Byte generateType(Byte type) {

        if (type == 5) {
//            increValue = redisStringAdapter.increment(getWxAppletTypeKey());
            return 6;
        }
        if (type == 6) {
//            increValue = redisStringAdapter.increment(getWxAppletFriendKey());
            return 8;
        }

        if (type == 9 || type == 10) {
            return type;
        }

        Long increValue = 0L;
        if (type == 1) {
            increValue = redisStringAdapter.increment(getWxTypeKey());
        }

        if (type == 2) {
            increValue = redisStringAdapter.increment(getWxFriendKey());
        }

        if (increValue % 2 == 1) {
            type = (byte) (type + 2);
        }

        return type;
    }

    /**
     * 对象转换
     *
     * @param locationRelation
     * @return
     */
    private LocationRelationDTO convertLocationRelation(LocationRelation locationRelation) {
        LocationRelationDTO locationRelationDTO = new LocationRelationDTO();

        locationRelationDTO.setContent(Objects.nonNull(locationRelation.getContent()) ? locationRelation.getContent() :
                locationProperties.getContent());
        locationRelationDTO.setId(locationRelation.getId());
        locationRelationDTO.setLocationCode(locationRelation.getLocationCode());
        locationRelationDTO.setType(locationRelation.getType());
        locationRelationDTO.setImgUrl(Objects.nonNull(locationRelation.getImgUrl()) ? locationRelation.getImgUrl() : locationProperties.getImgUrl());
        if (StringUtils.isEmpty(locationRelation.getContentDescription()) && Objects.nonNull(locationRelation.getContent())) {
            locationRelationDTO.setContentDescription(locationRelation.getContent());
        } else if(Objects.nonNull(locationRelation.getContentDescription())){
            locationRelationDTO.setContentDescription(locationRelation.getContentDescription());
        }else{
            locationRelationDTO.setContentDescription(locationProperties.getContentDesc());
        }
        locationRelationDTO.setWebShareDes(locationRelation.getWebShareDes());
        return locationRelationDTO;
    }

    private KeyGenerator getFixedShareCode() {
        return RedisConfig.WEIXIN_SHARE_FIXED_AREACODE.copy();
    }

    /**
     * 获取对应的微信分享类型的key
     */
    private KeyGenerator getWxTypeKey() {
        return RedisConfig.WEIXIN_LOCATION_RELATION.copy();
    }

    /**
     * 获取对应的微信朋友圈分享类型的key
     *
     * @return
     */
    private KeyGenerator getWxFriendKey() {

        return RedisConfig.WEIXIN_FRIEND_LOCATION_RELATION.copy();
    }

    /**
     * 获取对应的微信分享类型的key
     */
    private KeyGenerator getWxAppletTypeKey() {
        return RedisConfig.WEIXIN_APPLET_LOCATION_RELATION.copy();
    }

    /**
     * 获取对应的微信朋友圈分享类型的key
     *
     * @return
     */
    private KeyGenerator getWxAppletFriendKey() {

        return RedisConfig.WEIXIN_APPLET_FRIEND_LOCATION_RELATION.copy();
    }
}
