package com.bxm.localnews.base.service.impl;

import com.bxm.localnews.base.domain.BasePrivacyAgreementReportMapper;
import com.bxm.localnews.base.service.PrivacyAgreementReportService;
import com.bxm.localnews.common.config.PrivacyAgreementProperties;
import com.bxm.localnews.common.entity.BasePrivacyAgreementReport;
import com.bxm.localnews.common.param.PrivacyAgreeReportParam;
import com.bxm.localnews.thirdparty.service.PopService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.gexin.fastjson.JSON;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * 隐私协议弹窗上报service实现类
 *
 * @author wzy
 * @date 2020/8/15 14:55
 **/
@Service
public class PrivacyAgreementReportServiceImpl implements PrivacyAgreementReportService {
    @Resource
    private BasePrivacyAgreementReportMapper privacyAgreementReportMapper;

    @Resource
    private PrivacyAgreementProperties privacyAgreementProperties;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private PopService popService;

    @Override
    public int insertSelective(PrivacyAgreeReportParam param) {
        popService.addPrivacyPopCache(param.getUserId());
        Map<String, Object> privacyAgreeReportObject = new HashMap<>();
        privacyAgreeReportObject.put("text", privacyAgreementProperties.getText());
        privacyAgreeReportObject.put("replace", privacyAgreementProperties.getReplace());
        // 获取隐私协议内容
        String content = JSON.toJSONString(privacyAgreeReportObject);
        BasePrivacyAgreementReport basePrivacyAgreementReport =
                new BasePrivacyAgreementReport(param.getUserId(), param.getDevcId(), content);
        basePrivacyAgreementReport.setId(sequenceCreater.nextLongId());
        return privacyAgreementReportMapper.insertSelective(basePrivacyAgreementReport);
    }
}
