package com.bxm.localnews.base.service.manage;

import com.bxm.localnews.common.param.*;
import com.bxm.localnews.common.vo.DomainInfoVO;
import com.bxm.localnews.common.vo.DomainVO;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.List;

/**
 * @author gonzo
 * @date 2020-09-02 21:33
 **/
public interface DomainManageService {
    /**
     * 获取所有可用域名列表
     * @param param
     * @return
     */
    List<DomainVO> listAll(DomainListParam param);

    /**
     * 获取域名列表
     * @param param
     * @return
     */
    PageWarper<DomainVO> list(DomainListParam param);

    /**
     * 添加一个域名
     * @param param
     * @return
     */
    Message add(AddBaseDomainParam param);

    /**
     * 编辑一个域名
     * @param param
     * @return
     */
    Message edit(EditBaseDomainParam param);

    /**
     * 移除一个域名
     * @param id id
     * @return 移除结果
     */
    Message deleteOneDomain(Long id);

    /**
     * 域名投放列表
     * @param param
     * @return
     */
    PageWarper<DomainInfoVO> publishList(DomainPublishListParam param);

    /**
     * 添加域名投放
     * @param param
     * @return
     */
    Message publishAdd(AddDomainPublishParam param);

    /**
     * 编辑域名投放
     * @param param
     * @return
     */
    Message publishEdit(EditDomainPublishParam param);

    /**
     * 移除一个投放
     * @param id id
     * @return 移除结果
     */
    Message deleteOneDomainPublish(Long id);

    /**
     * 定时校验所有域名是否可用，下架并发送叮叮推送
     */
    void scheduleCheckDomain();
}
