/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.base.service.domain;

import com.bxm.localnews.base.service.domain.joins.DefaultSceneBaseUrlJointer;
import com.bxm.localnews.base.service.domain.joins.SceneBaseUrlJointer;
import com.bxm.localnews.common.constant.DomainScene;
import com.bxm.localnews.common.dto.JointerContext;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SceneBaseUrlJoiner {
    private static final Logger log = LoggerFactory.getLogger(SceneBaseUrlJoiner.class);
    private final Map<DomainScene, SceneBaseUrlJointer> JOINTER_MAP = Maps.newHashMap();
    private final DefaultSceneBaseUrlJointer defaultJointer;

    public SceneBaseUrlJoiner(List<SceneBaseUrlJointer> jointerList, DefaultSceneBaseUrlJointer defaultJointer) {
        jointerList.forEach(p -> {
            if (Objects.nonNull(p.support())) {
                this.JOINTER_MAP.put(p.support(), (SceneBaseUrlJointer)p);
            }
        });
        this.defaultJointer = defaultJointer;
    }

    public String joinByScene(DomainScene scene, DomainScene.DomainViewScene viewScene, String domainWithProtocol) {
        if (Objects.isNull(scene) || StringUtils.isBlank((CharSequence)domainWithProtocol)) {
            return "";
        }
        JointerContext context = new JointerContext();
        context.setUrl(domainWithProtocol);
        context.setScene(scene);
        context.setDomainViewScene(viewScene);
        SceneBaseUrlJointer jointer = this.JOINTER_MAP.get(scene);
        if (Objects.isNull(jointer)) {
            return this.defaultJointer.join(context);
        }
        return jointer.join(context);
    }
}

